<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
$page_title = 'تورنمنت‌ها';
include __DIR__.'/_layout_header.php';
$pdo = db();
$ts = $pdo->query("SELECT * FROM tournaments ORDER BY id DESC")->fetchAll();
?>
<div class="card">
  <?php if(is_admin()){ ?><a class="btn alt" href="<?=base_url('pages/tournament_create.php')?>">ایجاد تورنمنت</a><?php } ?>
</div>

<div class="grid cols-3">
<?php foreach($ts as $t){ ?>
  <div class="card">
    <div style="display:flex;align-items:center;gap:10px">
      <img src="<?=base_url($t['logo_url'] ?: 'assets/img/logo.png')?>" style="width:48px;height:48px;border-radius:12px;object-fit:cover">
      <div>
        <div><a href="<?=base_url('pages/tournament_view.php?id='.$t['id'])?>"><strong><?=h($t['title'])?></strong></a></div>
        <div class="small">ورودی: <?=number_format($t['entry_fee'])?> ت • وضعیت: <?=h($t['status'])?></div>
      </div>
    </div>
  </div>
<?php } ?>

</div>
<?php include __DIR__.'/_layout_footer.php';
