<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';

$tid = (int)($_GET['id'] ?? 0);
$pdo = db();

/* تورنمنت */
$ts = $pdo->prepare("SELECT * FROM tournaments WHERE id=?");
$ts->execute([$tid]);
$t = $ts->fetch();
if(!$t){ die('Tournament not found'); }

$page_title = 'تورنمنت: '.$t['title'];
include __DIR__.'/_layout_header.php';

$U = auth_user();

/* آیا کاربر تیمی دارد؟ و آیا همین تیم قبلاً ثبت شده؟ */
$userTeams = [];
if($U){
  $st = $pdo->prepare("SELECT t.* FROM teams t JOIN team_members m ON t.id=m.team_id WHERE m.user_id=?");
  $st->execute([$U['id']]);
  $userTeams = $st->fetchAll();
}

$alreadyReg = 0;
if($U && $userTeams){
  // با فرض «هر کاربر یک تیم»
  $chk = $pdo->prepare("SELECT COUNT(*) FROM tournament_teams WHERE tournament_id=? AND team_id=?");
  $chk->execute([$tid, $userTeams[0]['id']]);
  $alreadyReg = (int)$chk->fetchColumn();
}

/* لوگو و مشخصات */
$logo = $t['logo_url'] ?: 'assets/img/logo.png';
$maxTeamsTxt = $t['max_teams'] ? (int)$t['max_teams'] : 'بدون محدودیت';

/* Map Pool */
$pool = [];
if(!empty($t['map_pool'])){
  $pool = json_decode($t['map_pool'], true);
}
if(!$pool){
  $pool = defined('FW_MAP_POOL') ? FW_MAP_POOL : [];
}
?>
<!-- هِدِر تورنمنت -->
<div class="card">
  <div style="display:flex;align-items:center;gap:12px">
    <img src="<?=base_url($logo)?>" alt="لوگوی تورنمنت" style="width:56px;height:56px;border-radius:12px;object-fit:cover">
    <div>
      <h2 style="margin:0"><?=h($t['title'])?> <span class="badge"><?=h($t['status'])?></span></h2>
      <p class="small" style="margin:.25rem 0 0">
        ورودی تیم: <?=number_format((int)$t['entry_fee'])?> تومان | حداکثر تیم: <?=h($maxTeamsTxt)?>
        <?php if(!empty($t['schedule_start'])){ ?> | شروع: <?=h($t['schedule_start'])?><?php } ?>
      </p>
      <p class="small" style="margin:.25rem 0 0">Map Pool: <?=h(implode(', ', $pool))?></p>
    </div>
  </div>

  <?php if($t['status']=='open' && $U){ ?>
    <hr>
    <?php if(!$userTeams){ ?>
      <div class="small">شما هنوز عضوی از هیچ تیمی نیستید. ابتدا یک تیم بسازید یا به تیمی بپیوندید.</div>
    <?php } elseif($alreadyReg){ ?>
      <div class="small">تیم شما قبلاً برای این تورنمنت ثبت شده است.</div>
    <?php } else { ?>
      <form method="post" action="<?=base_url('actions/tournament_register_team.php')?>">
        <input type="hidden" name="tid" value="<?=$tid?>">
        <label>انتخاب تیم من</label>
        <select name="team_id" required>
          <?php foreach($userTeams as $tm){ echo '<option value="'.$tm['id'].'">'.h($tm['name']).'</option>'; } ?>
        </select>
        <button class="btn" style="margin-top:8px">ثبت تیم و پرداخت ورودی</button>
      </form>
    <?php } ?>
  <?php } ?>
</div>

<!-- پخش زنده تورنمنت (TV داخلیِ همین تورنمنت) -->
<?php
$noLiveImg = 'assets/img/no_live.jpg'; // اگر خواستی تصویر دلخواه بگذار
$hasStream = !empty($t['stream_url']);
$isLive    = !empty($t['is_live']);
if ($hasStream || is_file(__DIR__.'/../'.$noLiveImg)) {
?>
  <div class="card">
    <h3 style="margin-top:0">پخش زنده تورنمنت</h3>
    <?php if ($hasStream && $isLive) { ?>
      <div style="position:relative;padding-top:56.25%">
        <iframe
          src="<?=h($t['stream_url'])?>"
          allowfullscreen
          style="position:absolute;inset:0;width:100%;height:100%;border:0"
        ></iframe>
      </div>
    <?php } else { ?>
      <div style="display:flex;align-items:center;justify-content:center;min-height:200px;background:#0f141b;border-radius:12px;border:1px dashed #222">
        <div style="text-align:center">
          <img src="<?=base_url($noLiveImg)?>" alt="No live" style="width:120px;opacity:.6;display:block;margin:0 auto 8px">
          <div class="small" style="opacity:.8">در حال حاضر پخش زنده‌ای برای این تورنمنت فعال نیست.</div>
        </div>
      </div>
    <?php } ?>
  </div>
<?php } ?>

<!-- تیم‌های ثبت‌شده -->
<div class="card">
  <h3 style="margin:0 0 10px">تیم‌های ثبت‌شده</h3>
  <div class="grid cols-3">
  <?php
  $teams = $pdo->prepare("
    SELECT tt.*, t.name, t.logo_url
    FROM tournament_teams tt
    JOIN teams t ON t.id=tt.team_id
    WHERE tt.tournament_id=?
    ORDER BY (tt.seed IS NULL), tt.seed ASC, tt.id ASC
  ");
  $teams->execute([$tid]);
  foreach($teams as $tt){
    ?>
    <div class="card" style="padding:12px">
      <div style="display:flex;align-items:center;gap:10px">
        <img src="<?=base_url($tt['logo_url'] ?: 'assets/img/logo.png')?>" style="width:36px;height:36px;border-radius:50%;object-fit:cover">
        <div>
          <div><strong><?=h($tt['name'])?></strong></div>
          <div class="small"><?= $tt['paid'] ? 'پرداخت شده ✅' : 'در انتظار پرداخت ❌' ?></div>
        </div>
      </div>
      <div style="margin-top:8px;display:flex;gap:8px;align-items:center;flex-wrap:wrap">
        <button class="btn" onclick="viewTeam(<?= (int)$tt['team_id'] ?>)">مشاهده تیم</button>
        <?php if(!empty($tt['seed'])){ ?><span class="badge">Seed <?= (int)$tt['seed'] ?></span><?php } ?>
      </div>
    </div>
    <?php
  }
  ?>
  </div>
</div>

<?php
/* براکت: اگر ستون round وجود دارد بر اساس round گروه‌بندی می‌کنیم؛ وگرنه همه در یک ستون */
$hasRound = false;
try {
  $hasRound = (bool)$pdo->query("SHOW COLUMNS FROM matches LIKE 'round'")->fetch();
} catch(Throwable $e) { $hasRound = false; }

$sql = "SELECT m.*,
          ta.name a_name, ta.logo_url a_logo,
          tb.name b_name, tb.logo_url b_logo
        FROM matches m
        LEFT JOIN teams ta ON ta.id=m.team_a_id
        LEFT JOIN teams tb ON tb.id=m.team_b_id
        WHERE m.tournament_id=?
        ORDER BY ".($hasRound ? "m.round, " : "")."m.id";
$matches = $pdo->prepare($sql);
$matches->execute([$tid]);
$ms = $matches->fetchAll(PDO::FETCH_ASSOC);

/* گروه‌بندی برای نمایش */
$byRound = [];
if($hasRound){
  foreach($ms as $rm){ $byRound[(int)($rm['round'] ?? 1)][] = $rm; }
  ksort($byRound);
} else {
  $byRound[1] = $ms; // یک ستون ساده
}
?>

<!-- براکت شکیل -->
<div class="card">
  <h3 style="margin:0 0 10px">براکت</h3>
  <?php if (!$ms) { ?>
    <div class="small">هنوز مچی برای این تورنمنت ثبت نشده است.</div>
  <?php } else { ?>
    <div style="display:grid;grid-template-columns:repeat(<?=count($byRound)?>, minmax(220px, 1fr));gap:12px">
      <?php foreach($byRound as $r=>$arr){ ?>
        <div>
          <div style="margin-bottom:6px;font-weight:700;opacity:.9">Round <?= (int)$r ?></div>
          <?php foreach($arr as $mch){
            $aName = $mch['a_name'] ?: 'TBD';
            $bName = $mch['b_name'] ?: ($mch['team_b_id'] ? 'TBD' : 'BYE');
            $aLogo = base_url($mch['a_logo'] ?: 'assets/img/logo.png');
            $bLogo = base_url($mch['b_logo'] ?: 'assets/img/logo.png');

            // مرکز: وضعیت/نتیجه
            $center = 'VS';
            $stLower = strtolower($mch['status'] ?? '');
            if ($stLower === 'live') {
              $center = 'LIVE';
            } elseif ($stLower === 'done' || $stLower === 'finished') {
              $center = (int)$mch['score_a'].' : '.(int)$mch['score_b'];
            }
          ?>
            <div class="card" style="padding:10px;margin-bottom:8px">
              <div style="display:flex;align-items:center;justify-content:space-between;gap:8px">
                <div style="display:flex;align-items:center;gap:6px;min-width:0">
                  <img src="<?=$aLogo?>" style="width:22px;height:22px;border-radius:50%;object-fit:cover">
                  <span style="white-space:nowrap;overflow:hidden;text-overflow:ellipsis"><?=h($aName)?></span>
                </div>
                <div class="badge"><?=$center?></div>
                <div style="display:flex;align-items:center;gap:6px;min-width:0;justify-content:flex-end">
                  <span style="white-space:nowrap;overflow:hidden;text-overflow:ellipsis;text-align:right"><?=h($bName)?></span>
                  <img src="<?=$bLogo?>" style="width:22px;height:22px;border-radius:50%;object-fit:cover">
                </div>
              </div>
              <div style="display:flex;gap:8px;margin-top:8px;flex-wrap:wrap">
                <a class="btn" href="<?=base_url('pages/match_view.php?id='.$mch['id'])?>">مشاهده نتیجه</a>
                <a class="btn alt" href="<?=base_url('pages/match_lobby.php?id='.$mch['id'])?>">ورود به لابی</a>
                <?php if (is_admin()) { ?>
                  <a class="btn alt" href="<?=base_url('pages/match_manage.php?id='.$mch['id'])?>">ویرایش مسابقه</a>
                <?php } ?>
              </div>
            </div>
          <?php } ?>
        </div>
      <?php } ?>
    </div>
  <?php } ?>
</div>

<?php if (is_admin()) { ?>
  <div class="card" style="margin-top:12px;display:flex;gap:8px;justify-content:flex-end">
    <a class="btn" href="<?=base_url('pages/tournament_manage.php?id='.$tid)?>">مدیریت تورنمنت</a>
  </div>
<?php } ?>

<!-- Modal ساده برای نمایش اعضای تیم -->
<div id="teamModal" style="display:none; position:fixed; inset:0; background:rgba(0,0,0,.6);">
  <div style="background:#151A22; border:1px solid #222; border-radius:14px; max-width:520px; margin:60px auto; padding:16px">
    <div style="display:flex;justify-content:space-between;align-items:center">
      <strong>اعضای تیم</strong>
      <button class="btn" onclick="document.getElementById('teamModal').style.display='none'">×</button>
    </div>
    <div id="teamBody" style="margin-top:10px"></div>
  </div>
</div>
<script>
function viewTeam(teamId){
  fetch('<?=base_url('pages/xhr_team_members.php')?>?id='+teamId)
    .then(r=>r.text())
    .then(ht=>{
      document.getElementById('teamBody').innerHTML=ht;
      document.getElementById('teamModal').style.display='block';
    });
}
</script>

<?php include __DIR__.'/_layout_footer.php';
