<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
require_auth(); if(!is_admin()) die('Only admin');

$tid = (int)($_GET['id'] ?? 0);
$pdo = db();
$t = $pdo->prepare("SELECT * FROM tournaments WHERE id=?"); $t->execute([$tid]); $t=$t->fetch();
if(!$t) die('Tournament not found');

$page_title = 'چینش راند ۱: '.$t['title'];
include __DIR__.'/_layout_header.php';

$teams = $pdo->prepare("
  SELECT t.id, t.name, t.logo_url
  FROM tournament_teams tt
  JOIN teams t ON t.id=tt.team_id
  WHERE tt.tournament_id=?
  ORDER BY COALESCE(tt.seed, 999999), t.elo DESC, t.id ASC
");
$teams->execute([$tid]); $teams=$teams->fetchAll(PDO::FETCH_ASSOC);

// اگر قبلاً مچ ساخته شده، برگرد
$have = (int)$pdo->query("SELECT COUNT(*) FROM matches WHERE tournament_id=".$tid)->fetchColumn();
if($have>0){
  echo '<div class="card">براکت از قبل وجود دارد.</div>';
  include __DIR__.'/_layout_footer.php'; exit;
}
?>
<div class="card">
  <h3 style="margin:0 0 10px">چینش دستی (Round 1)</h3>
  <form method="post" action="<?=base_url('actions/tournament_seed_save.php')?>">
    <input type="hidden" name="tid" value="<?=$tid?>">
    <?php
      $n = count($teams);
      if($n<2){ echo '<div class="small">حداقل ۲ تیم لازم است.</div>'; }
      $rows = (int)ceil($n/2);
      // برای سادگی: به تعداد لازم، جفت انتخابی نشان بده
      for($i=1;$i<=$rows;$i++){
        ?>
        <div class="card" style="padding:10px;margin-bottom:8px">
          <strong>Match <?=$i?></strong>
          <div class="grid cols-2" style="margin-top:6px">
            <div>
              <label>Team A</label>
              <select name="pair[<?=$i?>][a]" required>
                <option value="">— انتخاب تیم —</option>
                <?php foreach($teams as $tm){ echo '<option value="'.$tm['id'].'">'.h($tm['name']).'</option>'; } ?>
                <option value="0">BYE</option>
              </select>
            </div>
            <div>
              <label>Team B</label>
              <select name="pair[<?=$i?>][b]" required>
                <option value="">— انتخاب تیم —</option>
                <?php foreach($teams as $tm){ echo '<option value="'.$tm['id'].'">'.h($tm['name']).'</option>'; } ?>
                <option value="0">BYE</option>
              </select>
            </div>
          </div>
        </div>
        <?php
      }
    ?>
    <button class="btn">ثبت چینش و ساخت مچ‌ها</button>
    <div class="small" style="margin-top:6px;opacity:.8">
      هر تیم فقط یک‌بار قابل استفاده است. اگر تیمی را دوبار بزنید، اکشن خطا می‌دهد.
    </div>
  </form>
</div>
<?php include __DIR__.'/_layout_footer.php';
