<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
require_auth(); if(!is_admin()) die('Only admin');

$pdo = db();
$tid = (int)($_GET['id'] ?? 0);
$t = $pdo->prepare("SELECT * FROM tournaments WHERE id=?");
$t->execute([$tid]);
$t = $t->fetch();
if(!$t) die('Tournament not found');

$page_title = 'مدیریت تورنمنت: '.$t['title'];
include __DIR__.'/_layout_header.php';

// تیم‌های ثبت‌شده در این تورنمنت
$teams = $pdo->prepare("
  SELECT tt.*, t.name, t.logo_url 
  FROM tournament_teams tt 
  JOIN teams t ON t.id=tt.team_id 
  WHERE tt.tournament_id=? 
  ORDER BY COALESCE(tt.seed, 999999), tt.id
");
$teams->execute([$tid]);
$teams = $teams->fetchAll();

// تیم‌هایی که هنوز اضافه نشده‌اند (برای افزودن دستی)
$available = $pdo->prepare("
  SELECT id, name FROM teams 
  WHERE id NOT IN (SELECT team_id FROM tournament_teams WHERE tournament_id=?) 
  ORDER BY id DESC LIMIT 100
");
$available->execute([$tid]);
$available = $available->fetchAll();

// آیا براکت/مچ داریم؟
$stHas = $pdo->prepare("SELECT COUNT(*) FROM matches WHERE tournament_id=?");
$stHas->execute([$tid]);
$hasMatches = (int)$stHas->fetchColumn() > 0;
?>
<?php if(!$hasMatches){ ?>
  <a class="btn" href="<?=base_url('pages/tournament_seed.php?id='.$tid)?>">چینش دستی راند ۱</a>
<?php } else { ?>
  <div class="small">براکت ساخته شده است.</div>
<?php } ?>

<div class="card">
  <h3 style="margin:0 0 12px">تنظیمات پایه</h3>
  <form method="post" action="<?=base_url('actions/tournament_update.php')?>" enctype="multipart/form-data">
    <input type="hidden" name="id" value="<?=$tid?>">
    <div class="grid cols-2">
  <div>
    <label>عنوان</label>
    <input name="title" value="<?=h($t['title'])?>" required>

    <label>ورودی هر تیم (تومان)</label>
    <input type="number" name="entry_fee" min="0" value="<?=h($t['entry_fee'])?>">

    <label>حداکثر تیم</label>
    <input type="number" name="max_teams" min="2" value="<?=h($t['max_teams'])?>">

    <label>تاریخ/ساعت شروع (میلادی)</label>
    <input name="schedule_start" value="<?=h($t['schedule_start'])?>" placeholder="YYYY-MM-DD HH:MM:SS">
  </div>

  <div>
    <label>لوگوی تورنمنت (PNG/JPG)</label>
    <input type="file" name="logo" accept=".png,.jpg,.jpeg">
    <?php if(!empty($t['logo_url'])){ ?>
      <div style="margin-top:8px"><img src="<?=base_url($t['logo_url'])?>" style="width:80px;border-radius:12px"></div>
    <?php } ?>

    <?php
      // گزینه‌های معتبر status از خود DB
      $statusOpts = [];
      try {
        $col = $pdo->query("SHOW COLUMNS FROM tournaments LIKE 'status'")->fetch(PDO::FETCH_ASSOC);
        if ($col && strpos(strtolower($col['Type'] ?? ''), 'enum(')!==false) {
          preg_match_all("/'([^']+)'/", $col['Type'], $mm);
          $statusOpts = $mm[1] ?? [];
        }
      } catch(Throwable $e) {}
    ?>
    <div>
      <label>وضعیت</label>
      <select name="status">
        <?php if ($statusOpts) {
          foreach($statusOpts as $opt){
            echo '<option value="'.h($opt).'" '.($t['status']===$opt?'selected':'').'>'.h($opt).'</option>';
          }
        } else {
          foreach (['draft','open','running','finished'] as $opt) {
            echo '<option value="'.h($opt).'" '.($t['status']===$opt?'selected':'').'>'.h($opt).'</option>';
          }
        } ?>
      </select>
    </div>

    <h4 style="margin-top:16px">پخش زنده</h4>
    <div class="grid cols-3">
      <div>
        <label>پلتفرم</label>
        <select name="stream_platform">
          <option value="">-</option>
          <option value="twitch"  <?=$t['stream_platform']==='twitch'?'selected':''?>>Twitch</option>
          <option value="youtube" <?=$t['stream_platform']==='youtube'?'selected':''?>>YouTube</option>
          <option value="other"   <?=$t['stream_platform']==='other'?'selected':''?>>دیگر</option>
        </select>
      </div>
      <div>
        <label>آدرس استریم (URL)</label>
        <input name="stream_url" value="<?=h($t['stream_url'])?>" placeholder="https://...">
      </div>
      <div>
        <label>در حال پخش؟</label>
        <select name="is_live">
          <option value="0" <?=$t['is_live']?'':'selected'?>>خیر</option>
          <option value="1" <?=$t['is_live']?'selected':''?>>بله</option>
        </select>
      </div>
    </div>
  </div> <!-- /col-2 راست -->

</div> <!-- /grid cols-2 -->
<button class="btn" style="margin-top:12px">ذخیره تنظیمات</button>
</form>
</div> <!-- /card تنظیمات پایه -->


<div class="card">
  <h3 style="margin:0 0 12px">تیم‌های ثبت‌شده</h3>
  <div class="grid cols-3">
    <?php foreach($teams as $tt){ ?>
      <div class="card" style="padding:10px">
        <div style="display:flex;align-items:center;gap:8px">
          <img src="<?=base_url($tt['logo_url'] ?: 'assets/img/logo.png')?>" style="width:28px;height:28px;border-radius:50%;object-fit:cover">
          <div>
            <div><strong><?=h($tt['name'])?></strong></div>
            <div class="small"><?= $tt['paid'] ? 'پرداخت شده ✅' : 'پرداخت نشده ❌' ?></div>
          </div>
        </div>
        <form method="post" action="<?=base_url('actions/tournament_team_remove.php')?>" onsubmit="return confirm('حذف تیم از تورنمنت؟')">
          <input type="hidden" name="tid" value="<?=$tid?>">
          <input type="hidden" name="team_id" value="<?=$tt['team_id']?>">
          <button class="btn danger" style="margin-top:8px">حذف از تورنمنت</button>
        </form>
      </div>
    <?php } if(!$teams){ ?>
      <div class="small">هنوز تیمی ثبت نشده.</div>
    <?php } ?>
  </div>

  <hr>
  <form method="post" action="<?=base_url('actions/tournament_team_add.php')?>">
    <input type="hidden" name="tid" value="<?=$tid?>">
    <label>افزودن تیم</label>
    <div style="display:flex;gap:8px">
      <select name="team_id" required>
        <option value="">انتخاب تیم...</option>
        <?php foreach($available as $opt){ ?>
          <option value="<?=$opt['id']?>"><?=h($opt['name'])?></option>
        <?php } ?>
      </select>
      <button class="btn">افزودن</button>
    </div>
  </form>
</div>

<div class="card">
  <h3 style="margin:0 0 12px">براکت</h3>
  <?php if($hasMatches){ ?>
    <div class="small">براکت/مچ‌ها قبلاً ساخته شده‌اند. برای ویرایش مچ‌ها به صفحهٔ مچ‌ها بروید.</div>
  <?php } else { ?>
    <form method="post" action="<?=base_url('actions/tournament_generate_bracket.php')?>" onsubmit="return confirm('براکت راند اول ساخته شود؟')">
      <input type="hidden" name="tid" value="<?=$tid?>">
      <p class="small">براساس تیم‌های ثبت‌شده، راند اول Single Elimination ساخته می‌شود (با BYE خودکار در صورت لزوم).</p>
      <button class="btn">تولید براکت (Round 1)</button>
    </form>
  <?php } ?>
</div>

<div class="card" style="border-color:#552; background:#1a1712">
  <h3 style="margin:0 0 12px">خطر! حذف تورنمنت</h3>
  <form method="post" action="<?=base_url('actions/tournament_delete.php')?>" onsubmit="return confirm('این تورنمنت و تمام مچ‌هایش حذف می‌شود. مطمئنید؟')">
    <input type="hidden" name="id" value="<?=$tid?>">
    <button class="btn danger">حذف تورنمنت</button>
  </form>
</div>

<?php include __DIR__.'/_layout_footer.php';
