<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
require_auth(); $U = auth_user();

$pdo = db();
$team = $pdo->prepare("SELECT * FROM teams WHERE captain_id=? LIMIT 1");
$team->execute([$U['id']]);
$team = $team->fetch();
$page_title = 'مدیریت تیم';
include __DIR__.'/_layout_header.php';

if(!$team){ echo '<div class="card">شما کپتن هیچ تیمی نیستید.</div>'; include __DIR__.'/_layout_footer.php'; exit; }

// اعضا
$members = $pdo->prepare("SELECT u.id uid, u.name, u.avatar_url, m.id mid, m.slot 
  FROM team_members m JOIN users u ON u.id=m.user_id WHERE m.team_id=? ORDER BY m.id");
$members->execute([$team['id']]); $members = $members->fetchAll();

// دعوت‌های باز
$invites = $pdo->prepare("SELECT * FROM invites WHERE team_id=? AND used_at IS NULL AND expires_at > NOW() ORDER BY id DESC");
$invites->execute([$team['id']]); $invites = $invites->fetchAll();
?>
<div class="grid cols-2">

  <div class="card">
    <h2>مدیریت تیم: <?=h($team['name'])?></h2>
    <form method="post" action="<?=base_url('actions/team_update_action.php')?>" enctype="multipart/form-data">
      <input type="hidden" name="team_id" value="<?=$team['id']?>">
      <label>نام تیم</label><input name="name" value="<?=h($team['name'])?>" required>
      <label>تگ</label><input name="tag" value="<?=h($team['tag'])?>" maxlength="6">
      <label>لوگو (PNG/JPG)</label><input type="file" name="logo" accept=".png,.jpg,.jpeg">
      <button class="btn" style="margin-top:8px">ذخیره</button>
    </form>
    <hr>
    <h3>اعضا (حداکثر ۶)</h3>
    <?php foreach($members as $m){ ?>
      <div style="display:flex;align-items:center;gap:8px;margin:6px 0">
        <img src="<?=h($m['avatar_url'])?>" style="width:28px;height:28px;border-radius:50%">
        <div style="flex:1"><?=h($m['name'])?></div>
        <form method="post" action="<?=base_url('actions/team_update_action.php')?>" style="display:inline">
          <input type="hidden" name="mid" value="<?=$m['mid']?>">
          <select name="slot">
            <option value="starter" <?=$m['slot']=='starter'?'selected':''?>>starter</option>
            <option value="sub" <?=$m['slot']=='sub'?'selected':''?>>sub</option>
          </select>
          <button class="btn" style="padding:6px 10px;margin-right:6px">تغییر نقش</button>
        </form>
        <?php if($m['uid'] != $U['id']){ ?>
        <form method="post" action="<?=base_url('actions/team_update_action.php')?>" onsubmit="return confirm('حذف این عضو؟')" style="display:inline">
          <input type="hidden" name="remove_mid" value="<?=$m['mid']?>">
          <button class="btn" style="background:#a33;padding:6px 10px">حذف</button>
        </form>
        <?php } ?>
      </div>
    <?php } ?>
  </div>

  <div class="card">
    <h3>دعوت عضو با لینک امن</h3>
    <form method="post" action="<?=base_url('actions/invite_create_action.php')?>">
      <input type="hidden" name="team_id" value="<?=$team['id']?>">
      <div class="grid cols-2">
        <div>
          <label>نقش عضو دعوت‌شونده</label>
          <select name="role"><option value="starter">starter</option><option value="sub">sub</option></select>
        </div>
        <div>
          <label>اعتبار لینک (ساعت)</label>
          <input type="number" name="hours" value="24" min="1">
        </div>
      </div>
      <button class="btn" style="margin-top:8px">ساخت لینک</button>
    </form>
    <?php if($invites){ echo '<hr><h4>لینک‌های فعال</h4>'; 
      foreach($invites as $iv){
        $url = base_url('actions/invite_accept.php?token='.$iv['token']);
        echo '<div class="small" style="margin:6px 0">'.$iv['role'].' | تا '.h($iv['expires_at']).' | <input value="'.h($url).'" style="width:100%"></div>';
      }
    } ?>
    <p class="small">لینک‌ها یک‌بارمصرف‌اند و بعد از استفاده یا انقضا باطل می‌شوند. هر کاربر فقط می‌تواند عضو **یک تیم** باشد؛ تیم حداکثر ۶ عضو دارد.</p>
  </div>

</div>
<?php include __DIR__.'/_layout_footer.php';
