<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
require_auth(); if(!is_admin()) die('Only admin');

$pdo = db();
$id = (int)($_GET['id'] ?? 0);
$st = $pdo->prepare("SELECT m.*, ta.name a_name, ta.logo_url a_logo, tb.name b_name, tb.logo_url b_logo
                     FROM matches m
                     LEFT JOIN teams ta ON ta.id=m.team_a_id
                     LEFT JOIN teams tb ON tb.id=m.team_b_id
                     WHERE m.id=?");
$st->execute([$id]);
$m = $st->fetch();
if(!$m) die('Match not found');

$maps = $pdo->prepare("SELECT * FROM match_maps WHERE match_id=? ORDER BY map_order");
$maps->execute([$id]);
$maps = $maps->fetchAll();

$page_title = 'مدیریت مچ #'.$id;
include __DIR__.'/_layout_header.php';

// Helper: وضعیت‌های مجاز match.status را بخوانیم
function fw_match_status_default($pdo){
  $col = $pdo->query("SHOW COLUMNS FROM matches LIKE 'status'")->fetch(PDO::FETCH_ASSOC);
  $status = $col['Default'] ?? 'scheduled';
  if (strpos(strtolower($col['Type'] ?? ''), 'enum(')!==false) {
    preg_match_all("/'([^']+)'/", $col['Type'], $mm); $opts = $mm[1] ?? [];
    foreach (['scheduled','live','done','running','open'] as $c)
      if (in_array($c,$opts,true)) { $status=$c; break; }
    if (!in_array($status,$opts,true) && $opts) $status=$opts[0];
  }
  return $status;
}
?>
<div class="card">
  <h2 style="margin:0 0 8px"><?=h($m['a_name']?:'TBD')?> <span class="badge">VS</span> <?=h($m['b_name']?:'TBD')?></h2>
  <div class="small">Match ID: <?=$id?></div>
</div>

<div class="grid cols-2">
  <div class="card">
    <h3>۱) شروع مچ / لایو</h3>
    <form method="post" action="<?=base_url('actions/match_save.php')?>">
      <input type="hidden" name="id" value="<?=$id?>">
      <input type="hidden" name="step" value="start">
      <label>زمان شروع (میلادی)</label>
      <input name="start_at" value="<?=h($m['start_at'])?>" placeholder="YYYY-MM-DD HH:MM:SS">
      <label>ID سرور (اختیاری)</label>
      <input type="number" name="server_id" value="<?=h($m['server_id'])?>" placeholder="server id">
      <label>وضعیت مچ</label>
      <select name="status">
        <?php
          $def = fw_match_status_default($pdo);
          // گزینه‌های محتمل:
          foreach(['scheduled','live','done','running','open'] as $opt){
            echo '<option value="'.$opt.'" '.($m['status']===$opt?'selected':'').'>'.$opt.'</option>';
          }
          // اگر وضعیت فعلی جزو این لیست نبود:
          if($m['status'] && !in_array($m['status'], ['scheduled','live','done','running','open'])){
            echo '<option value="'.h($m['status']).'" selected>'.h($m['status']).'</option>';
          }
        ?>
      </select>
      <button class="btn" style="margin-top:8px">ذخیره</button>
    </form>
  </div>

  <div class="card">
    <h3>۲) Knife Winner</h3>
    <form method="post" action="<?=base_url('actions/match_save.php')?>">
      <input type="hidden" name="id" value="<?=$id?>">
      <input type="hidden" name="step" value="knife">
      <label>برندهٔ نایف</label>
      <select name="knife_winner">
        <option value="">(نامشخص)</option>
        <option value="A" <?=$m['knife_winner']==='A'?'selected':''?>><?=h($m['a_name'])?> (A)</option>
        <option value="B" <?=$m['knife_winner']==='B'?'selected':''?>><?=h($m['b_name'])?> (B)</option>
      </select>
      <button class="btn" style="margin-top:8px">ذخیره</button>
    </form>
  </div>

  <div class="card">
    <h3>۳) انتخاب مپ‌ها (Bo3)</h3>
    <form method="post" action="<?=base_url('actions/match_save.php')?>">
      <input type="hidden" name="id" value="<?=$id?>">
      <input type="hidden" name="step" value="picks">
      <?php
        // سه ردیف مپ
        for($i=1;$i<=3;$i++){
          $row = null;
          foreach($maps as $mm) if((int)$mm['map_order']===$i) { $row=$mm; break; }
      ?>
      <div class="grid cols-3">
        <div>
          <label>مپ <?=$i?></label>
          <select name="map_name[<?=$i?>]">
            <option value="">-</option>
            <?php foreach(FW_MAP_POOL as $mp){ ?>
              <option value="<?=$mp?>" <?=($row && $row['map_name']===$mp)?'selected':''?>><?=$mp?></option>
            <?php } ?>
          </select>
        </div>
        <div>
          <label>انتخاب‌شده توسط</label>
          <select name="picked_by[<?=$i?>]">
            <option value="">-</option>
            <option value="A" <?=($row && $row['picked_by']==='A')?'selected':''?>>A (<?=h($m['a_name'])?>)</option>
            <option value="B" <?=($row && $row['picked_by']==='B')?'selected':''?>>B (<?=h($m['b_name'])?>)</option>
          </select>
        </div>
        <div class="small" style="display:flex;align-items:flex-end">* پس از ذخیره، در مرحلهٔ بعد امتیاز هر مپ را ثبت می‌کنید.</div>
      </div>
      <?php } ?>
      <button class="btn" style="margin-top:8px">ذخیره پیک‌ها</button>
    </form>
  </div>

  <div class="card">
    <h3>۴) امتیاز مپ‌ها</h3>
    <form method="post" action="<?=base_url('actions/match_save.php')?>">
      <input type="hidden" name="id" value="<?=$id?>">
      <input type="hidden" name="step" value="scores">
      <?php for($i=1;$i<=3;$i++){
        $row = null; foreach($maps as $mm) if((int)$mm['map_order']===$i) { $row=$mm; break; }
      ?>
      <div class="grid cols-3">
        <div><label>مپ <?=$i?></label><input value="<?=h($row['map_name']??'')?>" disabled></div>
        <div><label><?=h($m['a_name'])?> (A)</label><input type="number" name="sA[<?=$i?>]" min="0" value="<?=h($row['score_a']??'')?>"></div>
        <div><label><?=h($m['b_name'])?> (B)</label><input type="number" name="sB[<?=$i?>]" min="0" value="<?=h($row['score_b']??'')?>"></div>
      </div>
      <?php } ?>
      <button class="btn" style="margin-top:8px">ذخیره امتیاز مپ‌ها</button>
    </form>
  </div>

  <div class="card" style="border-color:#285a2a;background:#122016">
    <h3>۵) پایان مچ</h3>
    <form method="post" action="<?=base_url('actions/match_save.php')?>" onsubmit="return confirm('پایان مچ؟ نتیجه نهایی محاسبه و وضعیت به done تغییر می‌کند.')">
      <input type="hidden" name="id" value="<?=$id?>">
      <input type="hidden" name="step" value="finish">
      <button class="btn">پایان بازی و بستن لایو</button>
    </form>
  </div>
</div>

<?php include __DIR__.'/_layout_footer.php';
