<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php'; // ← این را اضافه کن
// require_once __DIR__.'/_debug_on.php';

$page_title='Leaderboard';

// ----- DEBUG HARNESS (نمایش خطا حتی وقتی display_errors خاموش است)
set_exception_handler(function($e){
  http_response_code(500);
  echo '<div class="card" style="border-color:#842029;color:#f8d7da;background:#1b2330">
        <strong>خطا:</strong> '.h($e->getMessage()).'</div>';
  exit;
});
set_error_handler(function($no,$str,$file,$line){
  throw new ErrorException($str, 0, $no, $file, $line);
});
// -------------------------------------

$page_title='Leaderboard';
include __DIR__.'/_layout_header.php';

$notes = []; // پیام‌های تشخیصی
try {
  // اتصال DB
  try { $pdo = db(); }
  catch(Throwable $e){ throw new RuntimeException('DB اتصال برقرار نشد: '.$e->getMessage()); }

  // گرفتن فصل‌ها (ممکنه جدول نباشه)
  $seasons = [];
  try {
    $seasons = $pdo->query("SELECT * FROM seasons ORDER BY is_active DESC, id DESC")->fetchAll();
  } catch(Throwable $e) {
    $notes[] = 'جدول seasons پیدا نشد (مشکل نیست؛ می‌رویم روی کل تاریخ).';
    $seasons = [];
  }

  // تعیین season id
  $sid = null;
  try {
    if(isset($_GET['season_id']) && $_GET['season_id']!==''){
      $sid = (int)$_GET['season_id'];
    } else {
      $sid = (int)$pdo->query("SELECT id FROM seasons WHERE is_active=1")->fetchColumn();
      if(!$sid) $sid = null;
    }
  } catch(Throwable $e) { $sid = null; }

  // خواندن داده‌ها
  $rows = [];
  $mode = 'all_time';
  if($sid){
    try{
      $stmt = $pdo->prepare("
        SELECT sr.team_id, sr.elo, t.name, t.logo_url
        FROM season_ratings sr
        JOIN teams t ON t.id=sr.team_id
        WHERE sr.season_id=?
        ORDER BY sr.elo DESC
        LIMIT 100
      ");
      $stmt->execute([$sid]);
      $rows = $stmt->fetchAll();
      $mode = 'season';
    }catch(Throwable $e){
      $notes[] = 'season_ratings در دسترس نیست: '.$e->getMessage().' — سوییچ به کل تاریخ.';
      $rows = $pdo->query("SELECT id AS team_id, name, logo_url, elo FROM teams ORDER BY elo DESC LIMIT 100")->fetchAll();
      $mode = 'all_time';
    }
  } else {
    $rows = $pdo->query("SELECT id AS team_id, name, logo_url, elo FROM teams ORDER BY elo DESC LIMIT 100")->fetchAll();
  }

} catch(Throwable $fatal) {
  // هر خطای غیرقابل پیش‌بینی را نشان بده
  echo '<div class="card" style="border-color:#842029;color:#f8d7da;background:#1b2330">
        <strong>خطای غیرمنتظره:</strong> '.h($fatal->getMessage()).'</div>';
  include __DIR__.'/_layout_footer.php';
  return;
}
?>
<div class="card">
  <form>
    <label>فصل</label>
    <select name="season_id" onchange="this.form.submit()">
      <option value="">(کل تاریخ)</option>
      <?php foreach($seasons as $s){ ?>
        <option value="<?=$s['id']?>" <?=$sid==$s['id']?'selected':''?>>
          <?=h($s['name'])?><?=$s['is_active']?' (active)':''?>
        </option>
      <?php } ?>
    </select>
  </form>
  <?php if($notes){ ?>
    <div class="small" style="opacity:.75;margin-top:6px">
      <?=h(implode(' | ',$notes))?>
    </div>
  <?php } ?>
</div>

<div class="card">
  <h3><?= $mode==='season' ? 'Leaderboard فصل' : 'Leaderboard کل تاریخ' ?></h3>
  <table class="table">
    <tr><th>#</th><th>تیم</th><th>Elo</th></tr>
    <?php $i=1; foreach($rows as $r){ ?>
      <tr>
        <td><?=$i++?></td>
        <td>
          <img src="<?=base_url($r['logo_url'] ?: 'assets/img/logo.png')?>"
               style="width:20px;height:20px;border-radius:50%;vertical-align:middle">
          <?=h($r['name'])?>
        </td>
        <td><?= (int)($r['elo'] ?? 0) ?></td>
      </tr>
    <?php } if(!$rows){ ?>
      <tr><td colspan="3" class="small">داده‌ای برای نمایش نیست.</td></tr>
    <?php } ?>
  </table>
</div>

<?php include __DIR__.'/_layout_footer.php';
