<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../db.php';

$page_title = 'خانه';
include __DIR__.'/_layout_header.php';

$pdo = db();
$ts = $pdo->query("SELECT * FROM tournaments ORDER BY id DESC LIMIT 12")->fetchAll();
?>
<div class="card"><h2>تورنمنت‌ها</h2></div>

<div class="grid cols-3">
<?php foreach ($ts as $t) {
  // آخرین/نزدیک‌ترین مچ این تورنمنت + لوگوی تیم‌ها
  $m = $pdo->prepare("
    SELECT m.*,
           ta.name a_name, ta.logo_url a_logo,
           tb.name b_name, tb.logo_url b_logo
    FROM matches m
    LEFT JOIN teams ta ON ta.id = m.team_a_id
    LEFT JOIN teams tb ON tb.id = m.team_b_id
    WHERE m.tournament_id = ?
    ORDER BY (m.status='live') DESC, m.start_at IS NULL, m.start_at ASC, m.id DESC
    LIMIT 1
  ");
  $m->execute([$t['id']]);
  $last = $m->fetch();
?>
  <div class="card">
    <div style="display:flex;align-items:center;gap:10px">
      <img
        src="<?=base_url($t['logo_url'] ?: 'assets/img/logo.png')?>"
        alt="لوگوی تورنمنت"
        style="width:40px;height:40px;border-radius:12px;object-fit:cover">
      <div>
        <div>
          <a href="<?=base_url('pages/tournament_view.php?id='.$t['id'])?>">
            <strong><?=h($t['title'])?></strong>
          </a>
        </div>
        <div class="small"><?=h($t['status'])?></div>
      </div>
    </div>
    <hr>
    <?php if ($last) { ?>
      <div style="display:flex;gap:6px;align-items:center;justify-content:space-between">
        <div style="display:flex;align-items:center;gap:6px">
          <img src="<?=base_url($last['a_logo'] ?: 'assets/img/logo.png')?>"
               style="width:20px;height:20px;border-radius:50%;object-fit:cover">
          <span><?=h($last['a_name'] ?: 'TBD')?></span>
        </div>
        <div class="badge">
          <?php
            if ($last['status'] === 'done') { echo (int)$last['score_a'].' : '.(int)$last['score_b']; }
            else { echo 'VS'; }
          ?>
        </div>
        <div style="display:flex;align-items:center;gap:6px">
          <img src="<?=base_url($last['b_logo'] ?: 'assets/img/logo.png')?>"
               style="width:20px;height:20px;border-radius:50%;object-fit:cover">
          <span><?=h($last['b_name'] ?: 'TBD')?></span>
        </div>
      </div>
    <?php } else { ?>
      <div class="small">هنوز مچی ثبت نشده</div>
    <?php } ?>
  </div>
<?php } ?>
</div>

<?php include __DIR__.'/_layout_footer.php';
