<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php'; // ← این را اضافه کن
// require_once __DIR__.'/_debug_on.php';
$page_title='Health Check';
include __DIR__.'/_layout_header.php';

function card($title, $ok, $msg=''){
  echo '<div class="card"><strong>'.$title.': '.($ok?'OK ✅':'FAIL ❌').'</strong>'.
       ($msg?'<div class="small" style="margin-top:4px">'.h($msg).'</div>':'').'</div>';
}

# DB
$db_ok=true; $db_msg='';
try { db()->query('SELECT 1')->fetchColumn(); }
catch(Throwable $e){ $db_ok=false; $db_msg=$e->getMessage(); }
card('Database', $db_ok, $db_msg);

# Helper: check url without requiring curl
function url_ok($url, &$err=''){
  if(function_exists('curl_init')){
    $ch=curl_init($url);
    curl_setopt_array($ch,[CURLOPT_NOBODY=>true,CURLOPT_RETURNTRANSFER=>true,CURLOPT_TIMEOUT=>8,CURLOPT_SSL_VERIFYPEER=>false]);
    curl_exec($ch);
    if(curl_errno($ch)){ $err=curl_error($ch); curl_close($ch); return false; }
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return ($code>=200 && $code<500);
  } else {
    // fallback
    $h=@get_headers($url);
    if($h===false){ $err='get_headers failed'; return false; }
    $code = (int)preg_replace('/\D/','',$h[0]??'0');
    return ($code>=200 && $code<500);
  }
}

$steam_ok = url_ok('https://steamcommunity.com/openid/login', $steam_msg);
card('Steam OpenID', $steam_ok, $steam_msg ?? '');

$zp_ok = url_ok('https://sandbox.zarinpal.com/pg/services/WebGate/service', $zp_msg);
card('Zarinpal Gateway', $zp_ok, $zp_msg ?? '');

include __DIR__.'/_layout_footer.php';
