<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
require_auth(); if(!is_admin()) die('Only admin');
$page_title = 'سرورها';
include __DIR__.'/_layout_header.php';
$ts = db()->query("SELECT id,title FROM tournaments ORDER BY id DESC")->fetchAll();
?>
<div class="card">
  <form method="post" action="<?=base_url('actions/server_add_action.php')?>">
    <label>نام سرور</label>
    <input name="name" required>
    <label>IP:Port</label>
    <input name="ip_port" required placeholder="1.2.3.4:27015">
    <label>Password (اختیاری)</label><input name="password">
    <label>RCON (اختیاری)</label><input name="rcon">
    <label>تورنمنت</label>
    <select name="tournament_id">
      <option value="">—</option>
      <?php foreach($ts as $t){ echo '<option value="'.$t['id'].'">'.h($t['title']).'</option>'; } ?>
    </select>
    <button class="btn" style="margin-top:8px">افزودن</button>
  </form>
</div>
<div class="card">
  <h3>لیست سرورها</h3>
  <table class="table">
    <tr><th>نام</th><th>آدرس</th><th>تورنمنت</th><th>یادداشت</th></tr>
    <?php 
    $rows = db()->query("SELECT s.*, t.title t_title FROM servers s LEFT JOIN tournaments t ON t.id=s.tournament_id ORDER BY s.id DESC");
    foreach($rows as $r){ ?>
      <tr><td><?=h($r['name'])?></td><td><?=h($r['ip_port'])?></td><td><?=h($r['t_title'])?></td><td><?=h($r['notes'])?></td></tr>
    <?php } ?>
  </table>
</div>
<?php include __DIR__.'/_layout_footer.php';
