<?php
require_once __DIR__.'/../helpers.php'; require_once __DIR__.'/../db.php'; require_once __DIR__.'/../lib/auth.php';
require_auth(); if(!is_admin()) die('Only admin');
$page_title='گزارش مالی'; include __DIR__.'/_layout_header.php';

$from = $_GET['from'] ?? date('Y-m-01');
$to   = $_GET['to']   ?? date('Y-m-d');
$pdo = db();

$sum = $pdo->prepare("SELECT 
  SUM(CASE WHEN ref_type='payment' AND direction='credit' THEN amount ELSE 0 END) pay_in,
  SUM(CASE WHEN ref_type='tournament_entry' AND direction='debit' THEN amount ELSE 0 END) entry_out,
  SUM(CASE WHEN ref_type='prediction' AND direction='credit' THEN amount ELSE 0 END) pred_out,
  SUM(CASE WHEN ref_type='prediction' AND direction='debit' THEN amount ELSE 0 END) pred_in
  FROM transactions WHERE DATE(created_at) BETWEEN ? AND ?");
$sum->execute([$from,$to]); $S=$sum->fetch();

$rows = $pdo->prepare("SELECT * FROM transactions WHERE DATE(created_at) BETWEEN ? AND ? ORDER BY id DESC LIMIT 500");
$rows->execute([$from,$to]); $rows=$rows->fetchAll();
?>
<div class="card">
  <form method="get" class="grid cols-3">
    <div><label>از</label><input name="from" value="<?=h($from)?>"></div>
    <div><label>تا</label><input name="to" value="<?=h($to)?>"></div>
    <div style="align-self:end">
      <button class="btn">فیلتر</button>
      <a class="btn alt" href="<?=base_url('actions/finance_export_csv.php?from=').urlencode($from).'&to='.urlencode($to)?>">خروجی CSV</a>
    </div>
  </form>
</div>

<div class="grid cols-4">
  <div class="card"><div class="small">شارژ کیف‌پول (ورودی)</div><h2><?=number_format((int)$S['pay_in'])?> ت</h2></div>
  <div class="card"><div class="small">ورودی تورنمنت (خروجی از کاربر)</div><h2><?=number_format((int)$S['entry_out'])?> ت</h2></div>
  <div class="card"><div class="small">پرداخت برد Prediction (خروجی)</div><h2><?=number_format((int)$S['pred_out'])?> ت</h2></div>
  <div class="card"><div class="small">Stake Prediction (ورودی)</div><h2><?=number_format((int)$S['pred_in'])?> ت</h2></div>
</div>

<div class="card">
  <h3>آخرین تراکنش‌ها (حداکثر ۵۰۰)</h3>
  <table class="table">
    <tr><th>ID</th><th>صاحب کیف‌پول</th><th>جهت</th><th>مبلغ</th><th>نوع</th><th>مرجع</th><th>تاریخ</th></tr>
    <?php foreach($rows as $r){ ?>
      <tr>
        <td><?=$r['id']?></td>
        <td><?=$r['wallet_owner_type'].'#'.$r['wallet_owner_id']?></td>
        <td><?=$r['direction']?></td>
        <td><?=number_format($r['amount'])?></td>
        <td><?=$r['ref_type']?></td>
        <td><?=$r['ref_id']?></td>
        <td><?=$r['created_at']?></td>
      </tr>
    <?php } ?>
  </table>
</div>
<?php include __DIR__.'/_layout_footer.php';
