<?php
require_once __DIR__.'/../helpers.php'; require_once __DIR__.'/../db.php'; require_once __DIR__.'/../lib/auth.php';
require_auth(); if(!(is_admin() || auth_user()['role']==='referee')) die('Only referee/admin');
$pdo=db(); $page_title='Disputes'; include __DIR__.'/_layout_header.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if($id){
  $d=$pdo->prepare("SELECT d.*, u.name uname FROM disputes d JOIN users u ON u.id=d.user_id WHERE d.id=?");
  $d->execute([$id]); $d=$d->fetch();
  $msgs=$pdo->prepare("SELECT m.*, u.name uname FROM dispute_messages m JOIN users u ON u.id=m.user_id WHERE dispute_id=? ORDER BY id");
  $msgs->execute([$id]); $msgs=$msgs->fetchAll();
  ?>
  <div class="card">
    <h3>#<?=$d['id']?> — <?=h($d['subject'])?> <span class="badge"><?=$d['status']?></span></h3>
    <p>ثبت‌کننده: <?=h($d['uname'])?> | مچ: #<?=$d['match_id']?> | تیم: <?=$d['team_id']?></p>
    <div class="card"><?=nl2br(h($d['body']))?></div>
    <?php foreach($msgs as $m){ echo '<div class="card"><strong>'.h($m['uname']).' ('.$m['role'].')</strong><div>'.nl2br(h($m['body'])).'</div></div>'; } ?>
    <form method="post" action="<?=base_url('actions/dispute_reply.php')?>">
      <input type="hidden" name="id" value="<?=$d['id']?>">
      <textarea name="body" rows="4" required></textarea>
      <button class="btn" style="margin-top:6px">ارسال پاسخ</button>
    </form>
    <form method="post" action="<?=base_url('actions/dispute_set_status.php')?>" style="margin-top:6px;display:flex;gap:6px">
      <input type="hidden" name="id" value="<?=$d['id']?>">
      <select name="status">
        <option value="in_review">in_review</option>
        <option value="resolved">resolved</option>
        <option value="rejected">rejected</option>
      </select>
      <button class="btn">تغییر وضعیت</button>
    </form>
  </div>
  <?php
}else{
  $rows=$pdo->query("SELECT d.id,d.subject,d.status,d.created_at,u.name uname FROM disputes d JOIN users u ON u.id=d.user_id ORDER BY FIELD(status,'open','in_review','resolved','rejected'), id DESC LIMIT 200")->fetchAll();
  echo '<div class="card"><h3>تیکت‌ها</h3><table class="table"><tr><th>ID</th><th>موضوع</th><th>وضعیت</th><th>توسط</th><th>تاریخ</th><th></th></tr>';
  foreach($rows as $r){ echo '<tr><td>'.$r['id'].'</td><td>'.h($r['subject']).'</td><td>'.$r['status'].'</td><td>'.h($r['uname']).'</td><td>'.$r['created_at'].'</td><td><a class="btn" href="'.base_url('pages/admin_disputes.php?id='.$r['id']).'">مشاهده</a></td></tr>'; }
  echo '</table></div>';
}
include __DIR__.'/_layout_footer.php';
