<?php
function steam_trust(string $steamid): array {
  $url="https://steamcommunity.com/profiles/{$steamid}/?xml=1";
  $ch=curl_init($url);
  curl_setopt_array($ch,[CURLOPT_RETURNTRANSFER=>true,CURLOPT_SSL_VERIFYPEER=>true,CURLOPT_TIMEOUT=>8]);
  $xml=curl_exec($ch); curl_close($ch);
  $out=['privacy'=>'unknown','memberSince'=>null,'vacBanned'=>null,'tradeBan'=>null];
  if(!$xml) return $out;
  libxml_use_internal_errors(true);
  $x=simplexml_load_string($xml); if(!$x) return $out;
  $out['privacy']=(string)$x->privacyState ?: 'unknown';
  $out['memberSince']=(string)$x->memberSince ?: null;
  $out['vacBanned']=isset($x->vacBanned) ? ((string)$x->vacBanned==='1' ? 'yes':'no') : null;
  $out['tradeBan']=(string)($x->tradeBanState ?? '');
  return $out;
}
