<?php
function steam_fetch_persona(string $steamid): array {
  // XML پروفایل پابلیک
  $url = "https://steamcommunity.com/profiles/{$steamid}/?xml=1";
  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER=>true,
    CURLOPT_SSL_VERIFYPEER=>true,
    CURLOPT_TIMEOUT=>10
  ]);
  $xml = curl_exec($ch);
  curl_close($ch);
  if (!$xml) return ['name'=>"Player_$steamid", 'avatar'=>'https://avatars.akamai.steamstatic.com/'];
  libxml_use_internal_errors(true);
  $x = simplexml_load_string($xml);
  if (!$x) return ['name'=>"Player_$steamid", 'avatar'=>'https://avatars.akamai.steamstatic.com/'];
  $name = (string)$x->steamID;
  $avatar = (string)$x->avatarMedium; // یا avatarFull
  return ['name'=>$name ?: "Player_$steamid", 'avatar'=>$avatar ?: 'https://avatars.akamai.steamstatic.com/'];
}
