<?php
// lib/rcon.php — مینیمال RCON (Source Engine / CS2)
// استفاده: $r=new SourceRcon('5.57.32.32', 28639, 'RCON_PASS'); $out=$r->command('status');
class SourceRcon {
  private $host, $port, $pass, $sock, $reqId=0;

  public function __construct(string $host, int $port, string $password){
    $this->host=$host; $this->port=$port; $this->pass=$password;
  }
  public function connect(int $timeout=3){
    $this->sock = @fsockopen('tcp://'.$this->host, $this->port, $errno, $errstr, $timeout);
    if(!$this->sock) throw new \RuntimeException("RCON connect failed: $errstr");
    stream_set_timeout($this->sock, $timeout);
    $this->auth();
  }
  private function writePacket(int $type, string $body){
    $this->reqId++;
    $payload = pack('VV', $this->reqId, $type) . $body . "\x00\x00";
    $packet  = pack('V', strlen($payload)) . $payload;
    fwrite($this->sock, $packet);
    return $this->reqId;
  }
  private function readPacket(){
    $lenData = fread($this->sock, 4);
    if(strlen($lenData) < 4) return [0,0,''];
    $len = unpack('V', $lenData)[1];
    $data = '';
    while(strlen($data) < $len){
      $chunk = fread($this->sock, $len - strlen($data));
      if($chunk === false || $chunk==='') break;
      $data .= $chunk;
    }
    if(strlen($data) < 8) return [0,0,''];
    $arr = unpack('Vid/Vtype', substr($data,0,8));
    $body = substr($data,8,-2);
    return [$arr['id'], $arr['type'], $body];
  }
  private function auth(){
    $this->writePacket(3, $this->pass); // SERVERDATA_AUTH=3
    [$id,$type,$body] = $this->readPacket(); // response
    if($id === -1){ throw new \RuntimeException('RCON auth failed'); }
  }
  public function command(string $cmd): string{
    if(!$this->sock) $this->connect();
    $this->writePacket(2, $cmd); // SERVERDATA_EXECCOMMAND=2
    // جمع کردن پاسخ‌ها
    $out='';
    do{
      [$id,$type,$body] = $this->readPacket();
      if($body==='') break;
      $out .= $body."\n";
      // بعضی سرورها پاسخ را در چند پکت می‌دهند
      if(strlen($body) < 3900) break;
    } while(true);
    return trim($out);
  }
  public function close(){ if($this->sock) fclose($this->sock); $this->sock=null; }
}
