<?php
require_once __DIR__.'/config.php';


function base_url($path = ''): string { return rtrim(FW_BASE_URL, '/').'/'.ltrim($path,'/'); }
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function redirect($path){ header('Location: '.base_url($path)); exit; }
function now(){ return date('Y-m-d H:i:s'); }


function is_admin(){ return isset($_SESSION['user']) && $_SESSION['user']['role']==='admin'; }
function require_auth(){ if(!isset($_SESSION['user'])) redirect('pages/login.php'); }

function fw_badge_for_elo(int $elo): array {
  if ($elo <= 1200) return ['برنز','assets/img/badge1.png'];
  if ($elo <= 1550) return ['سیلور','assets/img/badge2.png'];
  if ($elo <= 1900) return ['گلد','assets/img/badge3.png'];
  if ($elo <= 2100) return ['پلاتینیوم','assets/img/badge4.png'];
  return ['مَستر','assets/img/badge5.png'];
}
function audit(string $action, ?string $ref_type=null, ?int $ref_id=null, $before=null, $after=null): void {
  try{
    $pdo = db();
    $actor = null;
    if(function_exists('auth_user')){
      $u = auth_user();
      if($u) $actor = (int)$u['id'];
    }
    $ip = $_SERVER['REMOTE_ADDR'] ?? '';
    $bj = $before!==null ? json_encode($before, JSON_UNESCAPED_UNICODE) : null;
    $aj = $after!==null ? json_encode($after, JSON_UNESCAPED_UNICODE) : null;
    $stmt = $pdo->prepare("INSERT INTO audit_logs(actor_id,action,ref_type,ref_id,before_json,after_json,ip) VALUES(?,?,?,?,?,?,?)");
    $stmt->execute([$actor,$action,$ref_type,$ref_id,$bj,$aj,$ip]);
  }catch(Exception $e){
    // نذار خطای لاگ، روند اصلی رو خراب کنه
  }
}
function fw_upload_image(array $file, string $sub='general'): ?string {
  if(empty($file['tmp_name']) || $file['error']!==UPLOAD_ERR_OK) return null;
  $finfo = finfo_open(FILEINFO_MIME_TYPE);
  $mime = finfo_file($finfo, $file['tmp_name']); finfo_close($finfo);
  $ext = ($mime==='image/png')?'png':(($mime==='image/jpeg')?'jpg':null);
  if(!$ext) return null;
  @mkdir(__DIR__."/assets/img/{$sub}",0775,true);
  $name = $sub.'_'.date('Ymd_His').'_'.bin2hex(random_bytes(4)).'.'.$ext;
  $dest = __DIR__."/assets/img/{$sub}/".$name;
  if(!move_uploaded_file($file['tmp_name'], $dest)) return null;
  return "assets/img/{$sub}/".$name;
}
if(!function_exists('fw_digits_fa2en')){
  function fw_digits_fa2en(string $s): string {
    $fa = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
    $ar = ['٠','١','٢','٣','٤','٥','٦','٧','٨','٩'];
    $en = ['0','1','2','3','4','5','6','7','8','9'];
    return str_replace(array_merge($fa,$ar), array_merge($en,$en), $s);
  }
}

if(!function_exists('fw_parse_datetime')){
  function fw_parse_datetime(?string $s): ?string {
    $s = fw_digits_fa2en(trim((string)$s));
    if($s==='') return null;
    $s = preg_replace('/\s+/',' ',$s); // نرمال‌سازی فاصله
    // فرمت کامل
    $dt = DateTime::createFromFormat('Y-m-d H:i:s', $s);
    if(!$dt){
      // فقط تاریخ → ساعت پیش‌فرض 20:00
      $dt = DateTime::createFromFormat('Y-m-d', $s);
      if($dt){ $dt->setTime(20,0,0); }
    }
    return $dt ? $dt->format('Y-m-d H:i:s') : null;
  }
}
if (!function_exists('fw_fetch_steam_basic')) {
  function fw_fetch_steam_basic(string $steamid): array {
    // پیش‌فرض‌ها: حتی اگر هیچ چیزی نگرفتیم، با اینا برمی‌گردیم
    $name   = 'Player_'.$steamid;
    $avatar = '';
    $url    = "https://steamcommunity.com/profiles/{$steamid}/?xml=1";
    $xml    = '';

    // تلاش 1: cURL (پایدارتر روی هاست‌ها)
    if (function_exists('curl_init')) {
      $ch = curl_init($url);
      curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT        => 8,
        CURLOPT_USERAGENT      => 'FunWorld/1.0',
        CURLOPT_SSL_VERIFYPEER => true,
      ]);
      $tmp = curl_exec($ch);
      if ($tmp !== false) $xml = $tmp;
      curl_close($ch);
    }

    // تلاش 2: file_get_contents (اگر فعال باشد)
    if (!$xml && filter_var(ini_get('allow_url_fopen'), FILTER_VALIDATE_BOOLEAN)) {
      $ctx = stream_context_create([
        'http' => ['timeout'=>8,'header'=>"User-Agent: FunWorld/1.0\r\n"]
      ]);
      $tmp = @file_get_contents($url, false, $ctx);
      if ($tmp !== false) $xml = $tmp;
    }

    if ($xml) {
      if (function_exists('simplexml_load_string')) {
        libxml_use_internal_errors(true);
        $sx = @simplexml_load_string($xml);
        if ($sx) {
          $n = (string)$sx->steamID;
          $a = (string)$sx->avatarFull ?: (string)($sx->avatarMedium ?? '');
          if ($n) $name   = $n;
          if ($a) $avatar = $a;
        }
      } else {
        // fallback بدون SimpleXML
        if (preg_match('/<steamID>(.*?)<\/steamID>/u', $xml, $m)) {
          $name = html_entity_decode($m[1], ENT_QUOTES, 'UTF-8');
        }
        if (preg_match('/<avatarFull>(.*?)<\/avatarFull>/u', $xml, $m)) {
          $avatar = $m[1];
        } elseif (preg_match('/<avatarMedium>(.*?)<\/avatarMedium>/u', $xml, $m)) {
          $avatar = $m[1];
        }
      }
    }

    return [$name, $avatar];
  }
}

if (!function_exists('fw_map_img')) {
  function fw_map_img(string $map): string {
    // نرمال‌سازی نام‌ها
    $x = trim(strtolower($map));
    $x = str_replace(['de_',' '], ['',''], $x);
    // aliasها
    $aliases = [
      'dust2'  => 'dustii',
      'dust_ii'=> 'dustii',
      'dust'   => 'dustii',
    ];
    if (isset($aliases[$x])) $x = $aliases[$x];

    // اکستنشن‌های واقعی طبق فایل‌هایی که دادی
    $ext = [
      'ancient'=>'png','anubis'=>'png','dustii'=>'jpg','inferno'=>'png','italy'=>'jpg',
      'mirage'=>'png','nuke'=>'png','office'=>'jpg','overpass'=>'png','train'=>'png','vertigo'=>'png'
    ];
    $key = $x;
    if (!isset($ext[$key])) $key = 'mirage'; // fallback

    return base_url("assets/img/maps/".ucfirst($key).".".$ext[$key]);
  }
}

if (!function_exists('fw_team_member_ids')) {
  function fw_team_member_ids(PDO $pdo, int $team_id): array {
    // اگر ستون role داریم، starterها را اولویت بده
    $hasRole = false;
    try {
      $hasRole = (bool)$pdo->query("SHOW COLUMNS FROM team_members LIKE 'role'")->fetch();
    } catch(Throwable $e){}
    if ($hasRole) {
      $q = $pdo->prepare("SELECT user_id FROM team_members WHERE team_id=? AND (role='starter' OR role IS NULL) LIMIT 5");
      $q->execute([$team_id]);
    } else {
      $q = $pdo->prepare("SELECT user_id FROM team_members WHERE team_id=? LIMIT 5");
      $q->execute([$team_id]);
    }
    return array_map('intval', $q->fetchAll(PDO::FETCH_COLUMN));
  }
}

if (!function_exists('fw_user_in_match')) {
  function fw_user_in_match(PDO $pdo, int $match_id, int $user_id): bool {
    $m = $pdo->prepare("SELECT team_a_id, team_b_id FROM matches WHERE id=?");
    $m->execute([$match_id]); $m = $m->fetch();
    if (!$m) return false;
    $a = $pdo->prepare("SELECT 1 FROM team_members WHERE team_id=? AND user_id=? LIMIT 1");
    $a->execute([(int)$m['team_a_id'],$user_id]); $ia = (bool)$a->fetchColumn();
    if ($ia) return true;
    $b = $pdo->prepare("SELECT 1 FROM team_members WHERE team_id=? AND user_id=? LIMIT 1");
    $b->execute([(int)$m['team_b_id'],$user_id]); $ib = (bool)$b->fetchColumn();
    return $ib;
  }
}

if (!function_exists('fw_team_member_ids')) {
  function fw_team_member_ids(PDO $pdo, int $team_id): array {
    // اگر ستون role داریم، starterها را اولویت بده
    $hasRole = false;
    try {
      $hasRole = (bool)$pdo->query("SHOW COLUMNS FROM team_members LIKE 'role'")->fetch();
    } catch(Throwable $e){}
    if ($hasRole) {
      $q = $pdo->prepare("SELECT user_id FROM team_members WHERE team_id=? AND (role='starter' OR role IS NULL) LIMIT 5");
      $q->execute([$team_id]);
    } else {
      $q = $pdo->prepare("SELECT user_id FROM team_members WHERE team_id=? LIMIT 5");
      $q->execute([$team_id]);
    }
    return array_map('intval', $q->fetchAll(PDO::FETCH_COLUMN));
  }
}

if (!function_exists('fw_user_in_match')) {
  function fw_user_in_match(PDO $pdo, int $match_id, int $user_id): bool {
    $m = $pdo->prepare("SELECT team_a_id, team_b_id FROM matches WHERE id=?");
    $m->execute([$match_id]); $m = $m->fetch();
    if (!$m) return false;
    $a = $pdo->prepare("SELECT 1 FROM team_members WHERE team_id=? AND user_id=? LIMIT 1");
    $a->execute([(int)$m['team_a_id'],$user_id]); $ia = (bool)$a->fetchColumn();
    if ($ia) return true;
    $b = $pdo->prepare("SELECT 1 FROM team_members WHERE team_id=? AND user_id=? LIMIT 1");
    $b->execute([(int)$m['team_b_id'],$user_id]); $ib = (bool)$b->fetchColumn();
    return $ib;
  }
}

if (!function_exists('fw_map_img')) {
  function fw_map_img(string $map): string {
    // نرمال‌سازی
    $x = trim(mb_strtolower($map));
    $x = preg_replace('~^de_~i', '', $x);
    $x = str_replace(' ', '', $x);

    // نگاشت به "نام فایل دقیق" (همان‌هایی که در assets/img/maps داری)
    $files = [
      'ancient'  => 'Ancient.png',
      'anubis'   => 'Anubis.png',
      'dust2'    => 'DustII.jpg',
      'dustii'   => 'DustII.jpg',
      'dust'     => 'DustII.jpg',
      'inferno'  => 'Inferno.png',
      'italy'    => 'Italy.jpg',
      'mirage'   => 'Mirage.png',
      'nuke'     => 'Nuke.png',
      'office'   => 'Office.jpg',
      'overpass' => 'Overpass.png',
      'train'    => 'Train.png',
      'vertigo'  => 'Vertigo.png',
    ];

    $file = $files[$x] ?? 'Mirage.png'; // fallback معقول
    return base_url('assets/img/maps/'.$file);
  }
}
