<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
require_auth(); if(!is_admin()) die('Only admin');

$pdo = db();

/** خواندن گزینه‌های ENUM یک ستون (اگر ENUM نباشد، آرایه‌ی خالی می‌دهد) */
function fw_enum_options(PDO $pdo, string $table, string $column): array {
  try {
    $col = $pdo->query("SHOW COLUMNS FROM `{$table}` LIKE '{$column}'")->fetch(PDO::FETCH_ASSOC);
    if (!$col) return [];
    $type = strtolower($col['Type'] ?? '');
    if (strpos($type, "enum(") === false) return [];
    preg_match_all("/'([^']+)'/", $type, $m);
    return $m[1] ?? [];
  } catch (Throwable $e) { return []; }
}

/** نگاشت سینونیم‌ها به نزدیک‌ترین گزینه‌ی معتبر */
function fw_status_coerce(array $opts, ?string $want, ?string $default): string {
  $want = strtolower(trim((string)$want));
  if ($want && in_array($want, $opts, true)) return $want;
  // نگاشت‌های رایج
  $map = [
    'done'     => 'finished',
    'finish'   => 'finished',
    'ended'    => 'finished',
    'running'  => 'running',
    'live'     => 'running',
    'paused'   => 'open',     // اگر paused نداریم، نزدیک‌ترین حالت غیرتمام‌شده
    'open'     => 'open',
    'draft'    => 'draft',
    'start'    => 'open',
  ];
  if (isset($map[$want]) && in_array($map[$want], $opts, true)) return $map[$want];
  if ($default && in_array($default, $opts, true)) return $default;
  return $opts[0] ?? ($want ?: 'open');
}

try{
  $id        = (int)($_POST['id'] ?? 0);
  $title     = trim($_POST['title'] ?? '');
  $fee       = (int)($_POST['entry_fee'] ?? 0);
  $max       = (int)($_POST['max_teams'] ?? 0);
  $startRaw  = $_POST['schedule_start'] ?? '';
  $start     = fw_parse_datetime($startRaw);
  $plat      = $_POST['stream_platform'] ?: null;
  $surl      = trim($_POST['stream_url'] ?? '');
  $live      = (int)($_POST['is_live'] ?? 0);

  if(!$id || $title==='') throw new Exception('اطلاعات ناقص');

  // گزینه‌های معتبر status از DB
  $statusOpts = fw_enum_options($pdo, 'tournaments', 'status');
  $default    = null;
  try {
    $c = $pdo->query("SHOW COLUMNS FROM tournaments LIKE 'status'")->fetch(PDO::FETCH_ASSOC);
    $default = $c['Default'] ?? null;
  } catch (Throwable $e) {}
  $postedStatus = $_POST['status'] ?? null;
  $status = $statusOpts ? fw_status_coerce($statusOpts, $postedStatus, $default) : (string)$postedStatus;

  $logo = fw_upload_image($_FILES['logo'] ?? [], 'tournaments');

  $sql  = "UPDATE tournaments SET title=?, entry_fee=?, max_teams=?, status=?, schedule_start=?, stream_platform=?, stream_url=?, is_live=?";
  $vals = [$title, $fee, $max ?: null, $status, $start, $plat ?: null, ($surl ?: null), $live];

  if ($logo) { $sql .= ", logo_url=?"; $vals[] = $logo; }
  $sql .= " WHERE id=?";
  $vals[] = $id;

  $stmt = $pdo->prepare($sql);
  $stmt->execute($vals);

  audit('tournament.update','tournament',$id,null,['title'=>$title,'status'=>$status]);
  redirect('pages/tournament_manage.php?id='.$id);

}catch(Throwable $e){
  http_response_code(500);
  echo 'خطا: '.h($e->getMessage());
}
