<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
require_auth(); if(!is_admin()) die('Only admin');
$tid = (int)($_POST['tid'] ?? 0);
$pdo = db();


$teams = $pdo->prepare("SELECT tt.id tt_id, t.id team_id, t.elo FROM tournament_teams tt JOIN teams t ON t.id=tt.team_id WHERE tt.tournament_id=? AND tt.paid=1");
$teams->execute([$tid]);
$rows = $teams->fetchAll();
if(count($rows) < 2) die('تعداد تیم‌های پرداخت کرده کمتر از 2 است');


// sort desc by elo
usort($rows, fn($a,$b)=>$b['elo']<=>$a['elo']);
foreach($rows as $i=>$r){
$seed = $i+1;
$pdo->prepare("UPDATE tournament_teams SET seed=? WHERE id=?")->execute([$seed,$r['tt_id']]);
}


// ساخت مچ‌های Round 1 — pairing: 1vsN, 2vsN-1 ...
$N = count($rows);
for($i=0; $i<$N/2; $i++){
$a = $rows[$i]['team_id'];
$b = $rows[$N-$i-1]['team_id'];
$pdo->prepare("INSERT INTO matches(tournament_id,round,team_a_id,team_b_id,start_at) VALUES(?,?,?,?,NULL)")
->execute([$tid,1,$a,$b]);
}


// پیش‌ساخت راندهای بعدی (Placeholder)
$rCount = (int)ceil(log($N,2));
for($r=2;$r<=$rCount;$r++){
$mCount = (int)pow(2,$rCount-$r);
for($i=0;$i<$mCount;$i++){
$pdo->prepare("INSERT INTO matches(tournament_id,round) VALUES(?,?)")->execute([$tid,$r]);
}
}


// وضعیت تورنمنت به running
$pdo->prepare("UPDATE tournaments SET status='running' WHERE id=?")->execute([$tid]);
redirect('pages/tournament_view.php?id='.$tid);