<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
require_auth();
$U = auth_user();

$pdo = db();
$has = $pdo->prepare("SELECT COUNT(*) FROM team_members WHERE user_id=?");
$has->execute([$U['id']]);
if($has->fetchColumn()>0){ die('شما قبلاً عضو یک تیم هستید.'); }

$name = trim($_POST['name'] ?? '');
$tag  = trim($_POST['tag'] ?? '');
if($name===''){ die('نام تیم الزامی است'); }

$logoUrl = null;
if(!empty($_FILES['logo']['name'])){
  $ext = strtolower(pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION));
  if(!in_array($ext,['png','jpg','jpeg'])) die('فقط PNG/JPG مجاز است');
  $fname = 'team_'.time().'_'.mt_rand(1000,9999).'.'.$ext;
  $dest = __DIR__.'/../assets/img/'.$fname;
  if(!move_uploaded_file($_FILES['logo']['tmp_name'], $dest)) die('آپلود ناموفق بود');
  $logoUrl = 'assets/img/'.$fname;
}

$pdo->prepare("INSERT INTO teams(name,tag,captain_id,elo,calibration_left,logo_url) VALUES(?,?,?,1000,10,?)")
    ->execute([$name,$tag,$U['id'],$logoUrl]);

$team_id = (int)$pdo->lastInsertId();
$pdo->prepare("INSERT INTO team_members(team_id,user_id,slot) VALUES(?,?, 'starter')")
    ->execute([$team_id,$U['id']]);

redirect('pages/teams.php');
