<?php
require_once __DIR__.'/../helpers.php';
session_start();

$host = $_SERVER['HTTP_HOST'] ?? '';
$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$origin = $scheme.'://'.$host;                         // مثل https://amirhajian.com یا https://www.amirhajian.com
$allowed = 'amirhajian.com';
if(substr($host, -strlen($allowed)) !== $allowed){
  // اگر با دامنهٔ دیگری صدا زده شد، به دامنهٔ صحیح ریدایرکت
  header('Location: https://amirhajian.com/funworld/pages/login.php');
  exit;
}

$callback = $origin.'/funworld/actions/steam_callback.php';
$_SESSION['steam_login_origin'] = $origin;            // برای صحت‌سنجی موقع برگشت

$params = [
  'openid.ns'         => 'http://specs.openid.net/auth/2.0',
  'openid.mode'       => 'checkid_setup',
  'openid.claimed_id' => 'http://specs.openid.net/auth/2.0/identifier_select',
  'openid.identity'   => 'http://specs.openid.net/auth/2.0/identifier_select',
  'openid.return_to'  => $callback,
  'openid.realm'      => $origin
];
$qs = http_build_query($params);
header('Location: https://steamcommunity.com/openid/login?'.$qs);
exit;
