<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/openid.php';
require_once __DIR__.'/../lib/auth.php';

$logfile = __DIR__.'/../openid_debug.log';

// ادامه فایل اصلی تو…
function dbg($x){ global $logfile; @file_put_contents($logfile, '['.date('c')."] ".(is_string($x)?$x:print_r($x,true))."\n", FILE_APPEND); }

dbg('--- CALLBACK GET ---'); dbg($_GET);

$expected_return_to = base_url('actions/steam_callback.php');
$received_return_to = oid($_GET, 'openid.return_to'); // ← حالا کار می‌کند
dbg(['expected_return_to'=>$expected_return_to,'received_return_to'=>$received_return_to]);

if ($received_return_to !== $expected_return_to) {
  echo "Return_to mismatch<br>Expected: ".h($expected_return_to)."<br>Got: ".h((string)$received_return_to)."<br><br>";
  exit;
}

// اعتبارسنجی با Steam
$steamid = steam_openid_validate($_GET);
if(!$steamid){
  echo "Steam validation failed (post-check)."; exit;
}

// ساخت/ورود کاربر
$pdo = db();

// اسم/آواتار ایمن
list($nick, $avatar) = fw_fetch_steam_basic($steamid);
if (!$nick)   $nick   = 'Player_'.$steamid;
if (!$avatar) $avatar = '';

// تشخیص امن مقدار role بر اساس نوع ستون
$roleVal = 'player'; // پیش‌فرض امن
try {
  $col = $pdo->query("SHOW COLUMNS FROM users LIKE 'role'")->fetch(PDO::FETCH_ASSOC);
  if ($col) {
    $type = strtolower($col['Type']);
    if (strpos($type, 'enum') !== false) {
      // اگر enum بود و گزینه user داشت، همونو بزن؛ وگرنه player
      $roleVal = (strpos($type, "'user'") !== false) ? 'user' : 'player';
    } elseif (preg_match('/int|tinyint|smallint/', $type)) {
      // اگر عددی بود، 0 رو به عنوان user عادی بزن
      $roleVal = 0;
    } else {
      $roleVal = 'player';
    }
  }
} catch (Throwable $e) { /* نادیده بگیر */ }

try {
  $pdo->beginTransaction();

  // آیا قبلاً کاربر داریم؟
  $st = $pdo->prepare("SELECT * FROM users WHERE steam_id64=? LIMIT 1");
  $st->execute([$steamid]);
  $user = $st->fetch(PDO::FETCH_ASSOC);

  if ($user) {
    $newAvatar = $avatar ?: $user['avatar_url'];
    $upd = $pdo->prepare("UPDATE users SET name=?, avatar_url=? WHERE id=?");
    $upd->execute([$nick, $newAvatar, $user['id']]);
    $uid = (int)$user['id'];
  } else {
    // تشخیص ستون‌های اضافی
    $cols = [];
    try { $cols = $pdo->query("SHOW COLUMNS FROM users")->fetchAll(PDO::FETCH_COLUMN, 0); } catch(Throwable $e) {}
    $hasCal = in_array('calibration_left', $cols, true);
    $has18  = in_array('is_18_confirmed', $cols, true);

    // INSERT با placeholder برای role (نه مقدار ثابت) تا truncate نشه
    $sql = "INSERT INTO users(steam_id64,name,avatar_url,role,elo"
         . ($hasCal ? ",calibration_left" : "")
         . ($has18 ? ",is_18_confirmed" : "")
         . ") VALUES(?,?,?,?,?"
         . ($hasCal ? ",10" : "")
         . ($has18 ? ",0"  : "")
         . ")";
    $ins = $pdo->prepare($sql);
    $ins->execute([$steamid, $nick, $avatar, $roleVal, 1000]);
    $uid = (int)$pdo->lastInsertId();

    // والت اختیاری
    try {
      $pdo->prepare("INSERT IGNORE INTO wallets(owner_type,owner_id,balance) VALUES('user',?,0)")
          ->execute([$uid]);
    } catch (Throwable $e) {}
  }

  $pdo->commit();
  $user = $pdo->query("SELECT * FROM users WHERE id=".$uid)->fetch(PDO::FETCH_ASSOC);
  auth_login($user);
  redirect('pages/dashboard.php');

} catch (Throwable $e) {
  // لاگ امن
  $logDir = __DIR__.'/../logs';
  if (!is_dir($logDir)) { @mkdir($logDir, 0775, true); }
  @file_put_contents($logDir.'/login_errors.log', '['.date('c').'] '.$e->getMessage()."\n", FILE_APPEND | LOCK_EX);

  http_response_code(500);
  echo '<div style="padding:16px;background:#1b2330;color:#f8d7da;border:1px solid #842029;border-radius:8px;font-family:system-ui">';
  echo 'خطا در ورود: '.h($e->getMessage());
  echo '</div>';
  exit;
}
// لاگین طبق سیستم خودت
auth_login($user);
redirect('pages/dashboard.php');
