<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../db.php';
require_auth();
$U = auth_user();


$amount = max(1000, (int)($_POST['amount'] ?? 0)); // تومان
$meta = ['purpose'=>'wallet_topup'];


$pdo = db();
$pdo->prepare("INSERT INTO payments(user_id,provider,amount,currency,status,meta) VALUES(?,?,?,?,?,?)")
->execute([$U['id'],'zarinpal',$amount,'IRT','init',json_encode($meta,JSON_UNESCAPED_UNICODE)]);
$pid = (int)$pdo->lastInsertId();


// Zarinpal Request API
$req = [
'merchant_id' => ZP_MERCHANT,
'amount' => $amount * 10, // اگر API بر حسب ریال باشد، *10 کنید
'callback_url' => ZP_CALLBACK.'?pid='.$pid,
'description' => 'شارژ کیف پول '.FW_CREDIT_NAME,
];
$url = ZP_SANDBOX
? 'https://sandbox.zarinpal.com/pg/v4/payment/request.json'
: 'https://api.zarinpal.com/pg/v4/payment/request.json';


$ch = curl_init($url);
curl_setopt_array($ch,[CURLOPT_POST=>true,CURLOPT_POSTFIELDS=>json_encode($req),CURLOPT_HTTPHEADER=>['Content-Type: application/json'],CURLOPT_RETURNTRANSFER=>true]);
$res = curl_exec($ch);
curl_close($ch);
$data = json_decode($res,true);


if(isset($data['data']['authority'])){
$authority = $data['data']['authority'];
$pdo->prepare("UPDATE payments SET status='pending', authority=? WHERE id=?")->execute([$authority,$pid]);
$start = ZP_SANDBOX ? 'https://sandbox.zarinpal.com/pg/StartPay/' : 'https://payment.zarinpal.com/pg/StartPay/';
header('Location: '.$start.$authority);
exit;
}


echo 'خطا در اتصال به زرین‌پال';