<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
require_auth();

$pdo = db();
$U = auth_user();
$mid = (int)($_POST['match_id'] ?? 0);
$set = (int)($_POST['ready'] ?? 0);

$m = $pdo->prepare("SELECT id, team_a_id, team_b_id, server_window_until FROM matches WHERE id=?");
$m->execute([$mid]);
$M = $m->fetch();
if (!$M) { http_response_code(404); exit('match'); }

// فقط اعضای دو تیم
if (!fw_user_in_match($pdo, $mid, (int)$U['id'])) { http_response_code(403); exit('forbidden'); }

// ثبت
$pdo->prepare("REPLACE INTO match_ready(match_id,user_id,is_ready,ready_at) VALUES(?,?,?,NOW())")
    ->execute([$mid, (int)$U['id'], $set?1:0]);

// خروجی وضعیت (برای ajax)
function _cnt(PDO $pdo, int $mid, int $tid): array {
  $need = count(fw_team_member_ids($pdo, $tid)); if($need===0) $need=5;
  $q = $pdo->prepare("
    SELECT COUNT(*) FROM match_ready r 
    JOIN team_members m ON m.user_id=r.user_id 
    WHERE r.match_id=? AND r.is_ready=1 AND m.team_id=?");
  $q->execute([$mid,$tid]);
  return ['ready'=>(int)$q->fetchColumn(), 'need'=>$need];
}
$a = _cnt($pdo,$mid,(int)$M['team_a_id']);
$b = _cnt($pdo,$mid,(int)$M['team_b_id']);
echo json_encode([
  'a'=>$a,'b'=>$b,
  'all_ready'=> ($a['ready']>=$a['need'] && $b['ready']>=$b['need']) ? 1 : 0
]);
