<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../lib/rcon.php';
require_auth(); if(!is_admin()) die('Only admin');

$mid = (int)($_POST['match_id'] ?? 0);
$order = (int)($_POST['map_order'] ?? 1);

$pdo = db();
$m = $pdo->prepare("SELECT server_id FROM matches WHERE id=?");
$m->execute([$mid]); $serverId=(int)$m->fetchColumn();
if(!$serverId) redirect('pages/match_view.php?id='.$mid);

$mm = $pdo->prepare("SELECT id,map_name FROM match_maps WHERE match_id=? AND map_order=?");
$mm->execute([$mid,$order]); $row=$mm->fetch(PDO::FETCH_ASSOC);
if(!$row) redirect('pages/match_view.php?id='.$mid);

$s = $pdo->prepare("SELECT ip_port, rcon_password FROM servers WHERE id=?");
$s->execute([$serverId]); $sv=$s->fetch(PDO::FETCH_ASSOC);
[$host,$port] = explode(':',$sv['ip_port']) + [null,null];
$port=(int)$port;

function map_code2($n){ $n=strtolower($n); $n=preg_replace('/\.(png|jpg|jpeg)$/','',$n); $n=str_replace(['de_','cs_'],'',$n);
  $m=['mirage'=>'de_mirage','nuke'=>'de_nuke','inferno'=>'de_inferno','anubis'=>'de_anubis','overpass'=>'de_overpass','vertigo'=>'de_vertigo','dust2'=>'de_dust2','dust ii'=>'de_dust2','ancient'=>'de_ancient','train'=>'de_train','office'=>'cs_office','italy'=>'cs_italy']; return $m[$n]??('de_'.$n);
}

try{
  $r = new SourceRcon($host,$port,$sv['rcon_password']);

  // ensure match-level password
  $col = $pdo->query("SHOW COLUMNS FROM matches LIKE 'server_password'")->fetch();
  if($col){
    $pw = (string)$pdo->query("SELECT server_password FROM matches WHERE id=".$mid)->fetchColumn();
    if(!$pw){
      $pw = substr(bin2hex(random_bytes(6)),0,8);
      $pdo->prepare("UPDATE matches SET server_password=? WHERE id=?")->execute([$pw,$mid]);
    }
    $r->command('sv_password "'.$pw.'"');
  }

  $r->command('say "Loading map '.$row['map_name'].' ..."');
  $r->command('changelevel '.map_code2($row['map_name']));

  // state: می‌توانی ستون status در match_maps داشته باشی؛ اگر نبود، صرفاً نادیده بگیر
  $has = (bool)$pdo->query("SHOW COLUMNS FROM match_maps LIKE 'status'")->fetch();
  if($has){
    $pdo->prepare("UPDATE match_maps SET status='live' WHERE id=?")->execute([(int)$row['id']]);
  }

  $_SESSION['flash'] = 'Map '.$row['map_name'].' starting…';
}catch(Throwable $e){
  $_SESSION['flash'] = 'RCON ERR: '.$e->getMessage();
}
redirect('pages/match_view.php?id='.$mid);
