<?php
require_once __DIR__.'/../helpers.php'; require_once __DIR__.'/../db.php'; require_once __DIR__.'/../lib/auth.php';
require_auth(); if(!is_admin()) die('Only admin');
$from = $_GET['from'] ?? date('Y-m-01'); $to = $_GET['to'] ?? date('Y-m-d');
$pdo = db();
$rows = $pdo->prepare("SELECT * FROM transactions WHERE DATE(created_at) BETWEEN ? AND ? ORDER BY id DESC");
$rows->execute([$from,$to]);
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="finance_'.$from.'_'.$to.'.csv"');
$out = fopen('php://output','w');
fputcsv($out, ['id','owner_type','owner_id','direction','amount','ref_type','ref_id','memo','created_at']);
foreach($rows as $r){ fputcsv($out, [$r['id'],$r['wallet_owner_type'],$r['wallet_owner_id'],$r['direction'],$r['amount'],$r['ref_type'],$r['ref_id'],$r['memo'],$r['created_at']]); }
fclose($out);
