<?php
// bot/shopfun/webapp/support_lib.php
if (!defined('FW_INIT')) {
  define('FW_INIT', 1);
  date_default_timezone_set('Asia/Tehran');
}

/* --- ثابت‌ها (همه جا یکی) --- */
$WEBAPP_DIR  = __DIR__;
$ROOT_DIR    = realpath(dirname(__DIR__));
$DATA_DIR    = $ROOT_DIR . '/data';
$CAT_DIR     = $ROOT_DIR . '/category';
$SUPPORT_DIR = $WEBAPP_DIR . '/support';
$UPLOAD_DIR  = $WEBAPP_DIR . '/uploads';
@mkdir($DATA_DIR,    0777, true);
@mkdir($SUPPORT_DIR, 0777, true);
@mkdir($UPLOAD_DIR,  0777, true);

/* --- IO عمومی --- */
function fw_jload($p,$d=[]){ $t=@file_get_contents($p); if($t===false) return $d; $j=json_decode($t,true); return is_array($j)?$j:$d; }
function fw_jsave($p,$a){ @mkdir(dirname($p),0777,true); return @file_put_contents($p, json_encode($a,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT), LOCK_EX); }
function fw_txt_read($p,$def=''){ $t=@file_get_contents($p); return ($t===false)?$def:trim($t); }
function fw_txt_write($p,$val){ @mkdir(dirname($p),0777,true); return @file_put_contents($p, (string)$val, LOCK_EX); }

/* --- مسیر یکتا برای چت --- */
function fw_chat_primary($uid){ global $SUPPORT_DIR; return $SUPPORT_DIR.'/'.preg_replace('/\D/','',$uid).'/messages.json'; }
function fw_chat_legacy_list($uid){
  global $SUPPORT_DIR, $WEBAPP_DIR;
  $uid = preg_replace('/\D/','',$uid);
  return [
    $SUPPORT_DIR.'/'.$uid.'.json',
    dirname($WEBAPP_DIR).'/support/'.$uid.'/messages.json'
  ];
}

/* --- مهاجرتِ یک‌بار (اگر primary نبود) --- */
function fw_chat_migrate_once($uid){
  $primary = fw_chat_primary($uid);
  if (is_file($primary)) return $primary;
  $all=[]; $seen=[];
  foreach (fw_chat_legacy_list($uid) as $p){
    $arr = @json_decode(@file_get_contents($p),true) ?: [];
    foreach($arr as $m){
      $id = (int)($m['id']??0); if($id<=0 || isset($seen[$id])) continue;
      $seen[$id]=1; $all[]=$m;
    }
  }
  @mkdir(dirname($primary),0777,true);
  if ($all){
    usort($all,function($a,$b){ return ((int)($a['id']??0)) <=> ((int)($b['id']??0)); });
    fw_jsave($primary,$all);
    foreach (fw_chat_legacy_list($uid) as $p){ if (is_file($p)) @unlink($p); }
  } else {
    fw_jsave($primary,[]);
  }
  return $primary;
}

/* --- دیباگ اختیاری --- */
function fw_chat_debug_info($uid){
  $store = fw_chat_primary($uid);
  return [
    'store'=>$store,
    'exists'=>is_file($store),
    'count'=>count(fw_jload($store,[])),
  ];
}
