<?php
if (session_status()===PHP_SESSION_NONE) session_start();
error_reporting(0);
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__.'/support_lib.php';

/* Auth */
$auth_ok = false;
if (is_file(__DIR__.'/../auth.php')) { require_once __DIR__.'/../auth.php'; $auth_ok = function_exists('auth_user') ? !!auth_user() : !!($_SESSION['auth_user'] ?? null); }
elseif (is_file(__DIR__.'/../funs/auth.php')) { require_once __DIR__.'/../funs/auth.php'; $auth_ok = function_exists('auth_user') ? !!auth_user() : !!($_SESSION['auth_user'] ?? null); }
else { $auth_ok = !!($_SESSION['auth_user'] ?? null); }
if (!$auth_ok) { echo json_encode(['ok'=>false,'error'=>'NO_AUTH']); exit; }

function ok($a=[]){ echo json_encode(['ok'=>true]+$a,JSON_UNESCAPED_UNICODE); exit; }
function bad($m='error',$x=[]){ echo json_encode(['ok'=>false,'error'=>$m]+$x,JSON_UNESCAPED_UNICODE); exit; }

$uid = preg_replace('/\D/','', (string)($_POST['uid'] ?? ''));
$act = $_POST['action'] ?? 'send';
if (!$uid) bad('NO_UID');

$STORE = fw_chat_migrate_once($uid); // مسیر یکتا

if ($act === 'load') {
  $after = (int)($_POST['after'] ?? 0);
  $db = fw_jload($STORE, []);
  $out=[]; foreach($db as $m){ $id=(int)($m['id']??0); if($id>$after) $out[]=$m; }
  ok(['items'=>$out, 'debug'=>fw_chat_debug_info($uid)]);
}

/* send text or file */
$db = fw_jload($STORE, []);
$nextId = (count($db)? (int)end($db)['id'] : 0) + 1;

if (!empty($_FILES['file']['tmp_name'])) {
  global $UPLOAD_DIR;
  $ext  = strtolower(pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION));
  $type = (preg_match('/^audio/i', $_FILES['file']['type'])) ? 'audio' : 'image';
  $name = 'admin_'.$uid.'_'.time().'.'.$ext;
  $dst  = $UPLOAD_DIR.'/'.$name;

  if (@move_uploaded_file($_FILES['file']['tmp_name'],$dst)) {
    $db[] = ['id'=>$nextId,'ts'=>time(),'from'=>'admin','type'=>$type,'url'=>'uploads/'.$name];
    fw_jsave($STORE,$db);
    ok(['id'=>$nextId]);
  }
  bad('MOVE_FAILED');
} else {
  $text = trim((string)($_POST['text'] ?? ''));
  if ($text === '') bad('EMPTY');
  $db[] = ['id'=>$nextId,'ts'=>time(),'from'=>'admin','type'=>'text','text'=>$text];
  fw_jsave($STORE,$db);
  ok(['id'=>$nextId]);
}
