<?php
// bot/shopfun/webapp/index.php
// FunWorld Mini WebApp (Mobile-first) - سازگار با api.php فایل‌محور

header('X-Frame-Options: ALLOWALL');
?><!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1" />
<title>FunWorld WebApp</title>
<script src="https://telegram.org/js/telegram-web-app.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bodymovin/5.10.1/lottie.min.js"></script>
<style>
:root{--bg:#0b1220;--card:#0f172a;--muted:#94a3b8;--text:#e5e7eb;--line:#1f2937;--accent:#22d3ee}
*{box-sizing:border-box} html,body{margin:0;background:var(--bg);color:var(--text);font-family:IRANSans,ui-sans-serif,system-ui}
a{color:#93c5fd;text-decoration:none}
.container{max-width:720px;margin:0 auto;padding:12px}
.header{display:flex;align-items:center;justify-content:space-between;gap:10px;padding:8px 12px;border:1px solid var(--line);background:linear-gradient(180deg,#0f172a,#0b1220);border-radius:16px;position:sticky;top:0;z-index:10}
.h-left{display:flex;align-items:center;gap:8px}
.avatar{width:36px;height:36px;border-radius:999px;object-fit:cover;border:1px solid var(--line)}
.h-right{font-size:13px;color:var(--muted)} .h-right b{color:#fff}
.badge{border:1px solid var(--line);border-radius:999px;padding:2px 10px;background:#111827;font-size:12px}
.grid{display:grid;grid-template-columns:1fr;gap:12px}
.card{background:var(--card);border:1px solid var(--line);border-radius:18px;padding:14px}
.btn{width:100%;display:block;text-align:center;padding:12px 14px;border-radius:12px;border:1px solid var(--line);background:#162033;color:#e5e7eb;cursor:pointer}
.btn:hover{filter:brightness(1.05)}
.btn-primary{background:linear-gradient(180deg,#1f3a5c,#1a2c46);border-color:#254161}
.btn-ghost{background:#0b1220}
.btn-ok{background:#16351d;border-color:#235934}
.row{display:flex;align-items:center;gap:8px;flex-wrap:wrap}
.center{display:flex;align-items:center;justify-content:center}
.hidden{display:none}

/* Shop */
.topbar{display:flex;align-items:center;gap:8px;margin:10px 0}
.topbar .back{padding:8px 10px;border:1px solid var(--line);border-radius:10px;background:#0b1220}
.pill{padding:10px 12px;border-radius:999px;border:1px solid var(--line);background:#0d1626;cursor:pointer}
.pill.active{outline:2px solid #1f9dbe;background:#0f2032}
.list{display:flex;flex-direction:column;gap:8px;max-height:48vh;overflow:auto;border:1px dashed var(--line);border-radius:12px;padding:8px}
.item{border:1px solid var(--line);background:#0e1525;padding:12px;border-radius:12px}

/* Invoice */
.invoice{display:grid;gap:8px}
.kv{display:flex;align-items:center;justify-content:space-between;border-bottom:1px dashed var(--line);padding:6px 0;font-size:14px}

/* Account */
.acc-profile{display:flex;flex-direction:column;align-items:center;gap:6px}
.acc-cta{display:flex;gap:8px;flex-wrap:wrap}

/* Modal */
.modal{position:fixed;inset:0;background:rgba(0,0,0,.5);display:none;align-items:center;justify-content:center;padding:12px;z-index:50}
.modal .box{background:var(--card);border:1px solid var(--line);border-radius:16px;padding:14px;min-width:280px;max-width:420px}
.modal .head{display:flex;align-items:center;justify-content:space-between;margin-bottom:8px}
input,button,textarea{font:inherit}
.input{width:100%;padding:10px;border-radius:10px;border:1px solid var(--line);background:#0b1220;color:#e5e7eb}

/* Support chat */
.chatbox{height:60vh;overflow:auto;border:1px solid var(--line);border-radius:12px;padding:10px;display:flex;flex-direction:column;gap:8px;background:#0a121f}
.msg{max-width:80%;padding:8px 10px;border-radius:14px;font-size:14px}
.me{align-self:flex-end;background:#1d2a44}
.admin{align-self:flex-start;background:#111827}
.chat-input{display:flex;gap:6px;margin-top:8px}
.file{display:none}

/* Scroll */
.chatbox::-webkit-scrollbar,.list::-webkit-scrollbar{width:8px}
.chatbox::-webkit-scrollbar-thumb,.list::-webkit-scrollbar-thumb{background:#1e2b45;border-radius:8px}

/*top bar */
.topbar .back{
  padding:8px 10px;border:1px solid var(--line);
  border-radius:10px;background:#0b1220;color:#e5e7eb; /* 👈 رنگ متن */
}
.topbar .back:hover{ filter:brightness(1.05) }


/* Success screen */
#paidBox{display:none}
</style>
</head>
<body>
<div class="container">
  <header class="header">
    <div class="h-left">
      <img id="avatar" class="avatar" src="../assets/profile.png" alt="">
      <div>
        <div id="uname" style="font-size:13px;color:#cbd5e1">-</div>
        <div class="badge" id="uidBadge">UID: -</div>
      </div>
    </div>
    <div class="h-right">
      <span style="opacity:.8">مدیریت کیف پول | </span>
      موجودی شما: <b id="balance">0</b> تومان
    </div>
  </header>

  <!-- Home -->
  <section id="home" class="grid" style="margin-top:12px">
    <div class="card center">
      <div style="display:grid;gap:10px;min-width:260px;max-width:360px">
        <button class="btn btn-primary" onclick="nav('shop')">🛒 فروشگاه</button>
        <button class="btn" onclick="nav('account')">👤 حساب کاربری</button>
        <button class="btn" onclick="nav('support')">💬 پشتیبانی</button>
      </div>
    </div>
  </section>

  <!-- Shop -->
  <section id="shop" class="hidden">
    <div class="topbar"><button class="back" onclick="nav('home')">⟵ بازگشت</button></div>

    <div class="card" style="margin-bottom:10px">
      <div style="font-weight:700;margin-bottom:8px">لطفاً سرور خود را انتخاب کنید</div>
      <div class="row">
        <div id="srv1" class="pill" onclick="toggleSrv(1)">Fun City</div>
        <div id="srv2" class="pill" onclick="toggleSrv(2)">Fun Zone</div>
        <div class="row" style="margin-right:auto;gap:6px">
          <button class="btn-ghost btn" style="padding:8px 10px;width:auto" onclick="resetShop()">بازنشانی</button>
          <button id="goProducts" class="btn btn-primary" style="padding:8px 10px;width:auto" disabled onclick="loadProducts()">ادامه</button>
        </div>
      </div>
    </div>

    <div id="productsBox" class="card hidden">
      <div style="font-weight:700;margin-bottom:8px">محصولات</div>
      <div id="products" class="list"></div>
    </div>

    <div id="invoiceBox" class="card hidden">
      <div style="font-weight:700;margin-bottom:8px">پیش‌ فاکتور</div>
      <div class="invoice">
        <div class="kv"><span>نام محصول</span><b id="i_name">-</b></div>
        <div class="kv"><span>سرور(ها)</span><b id="i_srv">-</b></div>
        <div class="kv"><span>قیمت</span><b id="i_price">-</b></div>
        <div class="kv"><span>استیم آیدی شما</span>
          <span id="i_steam_box">
            <b id="i_steam">—</b>
            <button class="btn-ghost" style="padding:6px 10px;width:auto" onclick="askSteam()">ویرایش</button>
          </span>
        </div>
      </div>
      <div id="payBtns" class="row" style="margin-top:10px">
        <button class="btn btn-primary" onclick="payOnline()">پرداخت آنلاین</button>
        <button class="btn btn-ok" onclick="payWallet()">پرداخت از کیف پول</button>
      </div>
      <div id="needSteam" class="hidden" style="margin-top:8px;color:#eab308">لطفاً ابتدا استیم آیدی خود را وارد کنید.</div>
      <button class="btn btn-ghost" style="margin-top:8px" onclick="hideInvoice()">بازگشت</button>
    </div>
  </section>

  <!-- Account -->
  <section id="account" class="hidden">
    <div class="topbar"><button class="back" onclick="nav('home')">⟵ بازگشت</button></div>
    <div class="card">
      <div class="acc-profile">
        <img id="avatar2" class="avatar" src="../assets/profile.png" alt="" style="width:84px;height:84px;border-width:2px">
        <div id="hello" style="font-weight:700;margin-top:6px">خوش آمدی!</div>
        <div class="acc-cta">
          <button class="btn" style="width:auto" onclick="askSteam()">ویرایش استیم آیدی</button>
          <a id="steamLink" class="btn btn-ghost" style="width:auto" target="_blank" rel="noopener">مشاهده پروفایل استیم</a>
        </div>
        <div style="margin-top:8px;color:#9ca3af">استیم آیدی: <b id="steamId">—</b></div>
        <div style="margin-top:8px">موجودی کیف پول: <b id="balance2">0</b> تومان</div>
        <div class="row" style="margin-top:8px">
          <button class="btn btn-primary" style="width:auto" onclick="topup()">شارژ حساب</button>
        </div>
      </div>
    </div>

    <div class="card" style="margin-top:10px">
      <div style="font-weight:700;margin-bottom:8px">سابقه خرید</div>
      <div id="history" class="list"></div>
    </div>
  </section>

  <!-- Support -->
  <section id="support" class="hidden">
    <div class="topbar"><button class="back" onclick="nav('home')">⟵ بازگشت</button></div>
    <div class="card" style="margin-bottom:10px">
      <div style="font-weight:700;margin-bottom:6px">Fun World Support</div>
      <div class="chatbox" id="chat"></div>
      <div class="chat-input">
        <input id="chatText" class="input" placeholder="پیام خود را بنویسید...">
        <input id="chatFile" class="file" type="file" accept="image/*,audio/*" />
        <button class="btn btn-primary" style="width:auto" onclick="sendChat()">ارسال</button>
        <button class="btn" style="width:auto" onclick="selFile()">📎</button>
      </div>
    </div>
  </section>

  <!-- Paid success -->
  <section id="paidBox" class="card center" style="margin-top:10px">
    <div style="display:grid;gap:10px;place-items:center">
      <div id="anim" style="width:180px;height:180px"></div>
      <div style="font-weight:700">پرداخت شما موفقیت‌آمیز بود</div>
      <button class="btn btn-primary" onclick="nav('home')">برگشت به صفحه اصلی</button>
    </div>
  </section>
</div>

<!-- Modals -->
<div id="steamModal" class="modal" onclick="closeModal(event,'steamModal')">
  <div class="box" onclick="event.stopPropagation()">
    <div class="head"><b>استیم آیدی</b><button class="btn" style="width:auto" onclick="hide('steamModal')">✕</button></div>
    <input id="steamInput" class="input" placeholder="مثال: 76561198XXXXXXXXX">
    <div class="row" style="margin-top:8px">
      <button class="btn btn-primary" onclick="saveSteam()">ذخیره</button>
      <button class="btn btn-ghost" onclick="hide('steamModal')">انصراف</button>
    </div>
  </div>
</div>

<div id="topupModal" class="modal" onclick="closeModal(event,'topupModal')">
  <div class="box" onclick="event.stopPropagation()">
    <div class="head"><b>شارژ کیف پول</b><button class="btn" style="width:auto" onclick="hide('topupModal')">✕</button></div>
    <input id="topupInput" class="input" type="number" min="10000" step="10000" placeholder="مبلغ به تومان">
    <div class="row" style="margin-top:8px">
      <button class="btn btn-primary" onclick="doTopup()">ادامه به درگاه</button>
      <button class="btn btn-ghost" onclick="hide('topupModal')">انصراف</button>
    </div>
  </div>
</div>

<script>
/* ===== Helpers ===== */
const el=(id)=>document.getElementById(id);
const show=(id)=>el(id).classList.remove('hidden');
const hide=(id)=>el(id).classList.add('hidden');
function toast(m){ try{Telegram.WebApp.showAlert(m)}catch{alert(m)} }
function closeModal(e,id){ if(e.target.id===id) hide(id); }

let UID=null, USERNAME='', AVATAR='../assets/profile.png';
let BAL=0, STEAM='', SRV=new Set(), PRODUCT=null;
let LAST_ID=0, POLL=null;

/* ===== Init (Telegram + success redirect) ===== */
(function(){
  try{ const w=window.Telegram?.WebApp; w?.expand(); const u=w?.initDataUnsafe?.user; if(u?.id){ UID=String(u.id); USERNAME=(u.username||u.first_name||'کاربر'); AVATAR=u.photo_url||AVATAR; } }catch(e){}
  const q=new URLSearchParams(location.search);
  if(!UID && q.get('uid')) UID=String(q.get('uid'));
  el('avatar').src=AVATAR; el('avatar2').src=AVATAR;
  el('uidBadge').textContent='UID: '+(UID||'-');
  el('uname').textContent=USERNAME||'-';
  el('hello').textContent='خوش آمدی '+(USERNAME||'دوست من')+' 👋';
  if(q.get('paid')==='ok'){ showSuccess(); }
  refreshUser();
})();

/* ===== API wrapper ===== */
async function api(action, data={}, isForm=false){
  const body = isForm ? data : new URLSearchParams({...data, uid:UID});
  const res = await fetch('api.php?action='+encodeURIComponent(action), { method:'POST', body: body });
  return res.json();
}

/* ===== Navigation ===== */
function nav(id){
  ['home','shop','account','support'].forEach(s=>el(s).classList.toggle('hidden', s!==id));
  if(id==='account') loadAccount();
  if(id==='support'){ loadChat(true); startPolling(); } else stopPolling();
  if(id==='home'){ document.getElementById('paidBox').style.display='none'; }
}

/* ===== Shop ===== */
function totalPrice(p){ return (p.price||0) * (SRV.size===2 ? 2 : 1); }
function toggleSrv(n){ const p=el('srv'+n); if(SRV.has(n)){SRV.delete(n);p.classList.remove('active')}else{SRV.add(n);p.classList.add('active')} el('goProducts').disabled=(SRV.size===0); } 
if(PRODUCT){ document.getElementById('i_price').textContent = totalPrice(PRODUCT).toLocaleString()+' تومان'; }
function resetShop(){ SRV.clear(); ['srv1','srv2'].forEach(i=>el(i).classList.remove('active')); hide('productsBox'); hide('invoiceBox'); el('goProducts').disabled=true; }
async function loadProducts(){
  const r=await api('list_products', {});
  const box=el('products'); box.innerHTML='';
  (r.items||[]).forEach(p=>{
    const d=document.createElement('div'); d.className='item';
    d.innerHTML=`<div style="display:flex;align-items:center;justify-content:space-between;gap:8px">
      <div><div style="font-weight:700">${p.name}</div><div style="color:#9ca3af;font-size:12px">${p.code}</div></div>
      <div class="row"><div class="badge">${(p.price||0).toLocaleString()} تومان</div>
      <button class="btn btn-primary" style="width:auto" onclick='selectProduct(${JSON.stringify(p)})'>انتخاب</button></div></div>`;
    box.appendChild(d);
  });
  show('productsBox');
}
function selectProduct(p){
  PRODUCT=p;
  el('i_name').textContent=p.name;
  document.getElementById('i_price').textContent = totalPrice(p).toLocaleString()+' تومان';
  const s=[...SRV].sort().join(',')||'-'; el('i_srv').textContent=s.replace('1','Fun City').replace('2','Fun Zone').replace(',', ' + ');
  el('i_steam').textContent=STEAM||'—';
  el('needSteam').classList.toggle('hidden', !!STEAM);
  el('payBtns').classList.toggle('hidden', !STEAM);
  show('invoiceBox');
}
function hideInvoice(){ hide('invoiceBox'); }

/* ===== Account ===== */
async function loadAccount(){
  const r=await api('get_user', {});
  if(r.ok){
    BAL=r.balance||0; STEAM=r.steam||'';
    el('balance').textContent=BAL.toLocaleString();
    el('balance2').textContent=BAL.toLocaleString();
    el('steamId').textContent=STEAM||'—';
    el('i_steam').textContent=STEAM||'—';
    el('steamLink').href=STEAM?('https://steamcommunity.com/profiles/'+STEAM):'#';
    el('needSteam').classList.toggle('hidden', !!STEAM);
    el('payBtns').classList.toggle('hidden', !STEAM);
    const h=el('history'); h.innerHTML='';
    (r.history||[]).forEach(o=>{
      const d=document.createElement('div'); d.className='item';
      const st=o.status||'pending', color=st==='paid'?'#0ea5e9':(st==='done'?'#22c55e':'#eab308');
      d.innerHTML=`<div style="display:flex;justify-content:space-between;align-items:center;gap:6px">
        <div><div style="font-weight:700">${o.product}</div>
          <div style="color:#9ca3af;font-size:12px">${new Date((o.time||0)*1000).toLocaleString('fa-IR')}</div></div>
        <div class="row"><div class="badge" style="border-color:${color};color:${color}">${st}</div>
          <div class="badge">${(o.price||0).toLocaleString()} تومان</div></div></div>`;
      h.appendChild(d);
    });
  }
}
async function refreshUser(){ await loadAccount(); }

/* ===== Steam ===== */
function askSteam(){ el('steamInput').value=STEAM||''; show('steamModal'); }
async function saveSteam(){
  const v=el('steamInput').value.trim();
  if(!/^\d{10,20}$/.test(v)){ toast('استیم آیدی معتبر وارد کنید'); return; }
  const r=await api('set_steam',{steam:v});
  if(r.ok){ STEAM=v; hide('steamModal'); loadAccount(); toast('ذخیره شد'); } else toast('خطا در ذخیره');
}

/* ===== Topup via gateway ===== */
function topup(){ el('topupInput').value=''; show('topupModal'); }
async function doTopup(){
  const amount=parseInt(el('topupInput').value||'0',10);
  if(amount<10000){ toast('حداقل ۱۰,۰۰۰ تومان'); return; }
  const r=await api('charge_link',{amount});
  if(r.ok && r.url){ location.href=r.url; } else toast('خطا در ساخت لینک پرداخت');
}

/* ===== Payments ===== */
function srvStr(){ return [...SRV].sort().join(','); }
function ensureSteam(){ const ok=!!STEAM; el('needSteam').classList.toggle('hidden',ok); el('payBtns').classList.toggle('hidden',!ok); return ok; }
async function payOnline(){
  if(!PRODUCT){ toast('محصولی انتخاب نشده'); return; }
  if(!ensureSteam()){ toast('ابتدا استیم آیدی را وارد کنید'); return; }
  const r=await api('pay_online',{pid:PRODUCT.code, servers:srvStr()});
  if(r.ok && r.url){ location.href=r.url; } else toast('خطا در ساخت لینک پرداخت');
}
async function payWallet(){
  if(!PRODUCT){ toast('محصولی انتخاب نشده'); return; }
  if(!ensureSteam()){ toast('ابتدا استیم آیدی را وارد کنید'); return; }
  const r=await api('pay_wallet',{pid:PRODUCT.code, price:PRODUCT.price, servers:srvStr()});
  if(r.ok){ showSuccess(); refreshUser(); hide('invoiceBox'); }
  else toast(r.error||'عدم کفایت موجودی کیف پول');
}

/* ===== Success animation ===== */
// جایگزین تابع showSuccess()
function showSuccess(){
  ['home','shop','account','support'].forEach(s=>document.getElementById(s).classList.add('hidden'));
  document.getElementById('paidBox').style.display='block';
  fetch('../assets/confirmed.json').then(r=>r.json()).then(data=>{
    lottie.loadAnimation({container:document.getElementById('anim'),renderer:'svg',loop:false,autoplay:true,animationData:data});
  });
  // 👇 پارامتر paid=ok را از URL پاک کن تا دوباره نمایش نگیرد
  try{
    const u=new URL(location.href); u.searchParams.delete('paid');
    history.replaceState({}, '', u.toString());
  }catch{}
}

// در nav(id) این خط را به ابتدای تابع اضافه کن:


/* ===== Support chat ===== */
function chatAppend(m){
  const box=el('chat'); const div=document.createElement('div');
  div.className='msg '+(m.from==='admin'?'admin':'me');
  if(m.type==='text'){ div.textContent=m.text; }
  else if(m.type==='image'){ div.innerHTML=`<img src="${m.url}" style="max-width:70%;border-radius:10px">`; }
  else if(m.type==='audio'){ div.innerHTML=`<audio controls src="${m.url}"></audio>`; }
  box.appendChild(div); box.scrollTop=box.scrollHeight;
  LAST_ID=Math.max(LAST_ID, m.id||0);
}
async function loadChat(reset=false){
  if(reset){ el('chat').innerHTML=''; LAST_ID=0; }
  const r=await api('support_load',{after:0});
  (r.items||[]).forEach(chatAppend);
}
function startPolling(){ stopPolling(); POLL=setInterval(async()=>{ const r=await api('support_load',{after:LAST_ID}); (r.items||[]).forEach(chatAppend); },2000); }
function stopPolling(){ if(POLL){ clearInterval(POLL); POLL=null; } }
async function sendChat(){
  const t=el('chatText').value.trim(); const f=el('chatFile').files[0];
  if(f){
    const fd=new FormData(); fd.append('uid',UID); fd.append('file',f); fd.append('action','support_send_file');
    const r=await fetch('api.php?action=support_send_file',{method:'POST',body:fd}).then(r=>r.json());
    if(r.ok){ el('chatFile').value=''; }
  }else if(t){
    const r=await api('support_send',{text:t});
    if(r.ok){ el('chatText').value=''; }
  }
}
function selFile(){ el('chatFile').click(); }
</script>
</body>
</html>
