<?php
if (session_status()===PHP_SESSION_NONE) session_start();
header('Content-Type: application/json; charset=utf-8');
header('X-Frame-Options: ALLOWALL');
require_once __DIR__.'/support_lib.php';

/* شورت‌کات‌های لوکال از هِلپر */
$WEBAPP_DIR=$WEBAPP_DIR; $ROOT_DIR=$ROOT_DIR; $DATA_DIR=$DATA_DIR; $CAT_DIR=$CAT_DIR; $UPLOAD_DIR=$UPLOAD_DIR;

function ok($a=[]){ echo json_encode(['ok'=>true]+$a,JSON_UNESCAPED_UNICODE); exit; }
function bad($m='error',$x=[]){ echo json_encode(['ok'=>false,'error'=>$m]+$x,JSON_UNESCAPED_UNICODE); exit; }
function need_uid($u){ if(!$u) bad('NO_UID'); }
function udir($uid){ global $DATA_DIR; return $DATA_DIR.'/'.preg_replace('/\D/','',$uid); }
function ufile($uid,$name){ return udir($uid).'/'.$name; }

$action = $_GET['action'] ?? ($_POST['action'] ?? '');
$UID    = isset($_POST['uid']) ? preg_replace('/\D/','', (string)$_POST['uid']) : '';

/* محصولات از هاست */
function load_products(){
  global $CAT_DIR; $out=[];
  $pj=$CAT_DIR.'/products.json';
  if (is_file($pj)){
    $arr=json_decode(@file_get_contents($pj),true);
    if (is_array($arr)){ foreach($arr as $p){ if(!isset($p['code'])) continue; $out[]=['code'=>$p['code'],'name'=>$p['name']??$p['code'],'price'=>(int)($p['price']??0)]; } return $out; }
  }
  if (is_dir($CAT_DIR)){
    foreach((array)glob($CAT_DIR.'/*',GLOB_ONLYDIR) as $dir){
      $code=basename($dir);
      $name=is_file($dir.'/name.txt')?trim(@file_get_contents($dir.'/name.txt')):$code;
      $price=is_file($dir.'/price.txt')?(int)trim(@file_get_contents($dir.'/price.txt')):0;
      $out[]=['code'=>$code,'name'=>$name,'price'=>$price];
    }
  }
  return $out;
}

/* پروفایل کاربر */
function get_profile($uid){
  $ud=udir($uid); @mkdir($ud,0777,true);
  $balance=(int)fw_txt_read($ud.'/price.txt','0');
  $steam  =fw_txt_read($ud.'/steamid.txt','');
  $server =fw_txt_read($ud.'/server.txt','');
  $username=fw_txt_read($ud.'/last.txt','');
  $avatar=is_file($ud.'/avatar.jpg')?('../data/'.$uid.'/avatar.jpg'):'../assets/profile.png';
  $orders=fw_jload($ud.'/orders.json',[]);
  return compact('balance','steam','server','username','avatar','orders');
}

try{
  switch($action){

    case 'get_user': {
      need_uid($UID);
      $p=get_profile($UID);
      ok([
        'balance'=>(int)$p['balance'],
        'steam'=>$p['steam'],
        'username'=>$p['username'],
        'avatar'=>$p['avatar'],
        'history'=>array_map(fn($o)=>[
          'product'=>$o['product']??'','price'=>(int)($o['price']??0),
          'status'=>$o['status']??'pending','time'=>(int)($o['time']??0),'server'=>$o['server']??'',
        ], $p['orders'])
      ]);
    }

    case 'set_steam': {
      need_uid($UID);
      $steam=trim($_POST['steam']??'');
      if(!preg_match('/^\d{10,20}$/',$steam)) bad('INVALID_STEAM');
      fw_txt_write(ufile($UID,'steamid.txt'),$steam);
      ok();
    }

    case 'list_products': { ok(['items'=>load_products()]); }

    case 'pay_online': {
      need_uid($UID);
      $pid=trim($_POST['pid']??''); $servers=trim($_POST['servers']??'');
      if($pid==='') bad('NO_PRODUCT');
      $price=0; $pname=''; $found=false;
      foreach(load_products() as $p){ if($p['code']===$pid){ $price=(int)$p['price']; $pname=$p['name']; $found=true; break; } }
      if(!$found) bad('PRODUCT_NOT_FOUND');
      $norm=str_replace('+',',',preg_replace('/\s+/','',$servers));
      if($norm==='1,2'||$norm==='2,1') $price*=2;
      fw_txt_write(ufile($UID,'server.txt'),$servers);
      ok(['url'=>"../pay.php?pay={$price}&from={$UID}&pid=".rawurlencode($pid)."&srv=".rawurlencode($servers)."&as=webapp"]);
    }

    case 'charge_link': {
      need_uid($UID);
      $amount=(int)($_POST['amount']??0);
      if($amount<10000) bad('MIN_10000');
      ok(['url'=>"../pay.php?pay={$amount}&from={$UID}&as=webapp"]);
    }

    case 'pay_wallet': {
      need_uid($UID);
      $pid=trim($_POST['pid']??''); $price=(int)($_POST['price']??0); $servers=trim($_POST['servers']??'');
      if($pid===''||$price<=0) bad('BAD_INPUT');
      $prof=get_profile($UID);
      if(!$prof['steam']) bad('STEAM_REQUIRED');
      if((int)$prof['balance']<$price) bad('INSUFFICIENT_FUNDS');
      $pname=$pid; foreach(load_products() as $p){ if($p['code']===$pid){ $pname=$p['name']; break; } }
      $newBal=(int)$prof['balance']-$price;
      fw_txt_write(ufile($UID,'price.txt'),$newBal);
      if($servers!=='') fw_txt_write(ufile($UID,'server.txt'),$servers);
      $ud=udir($UID); $orders=fw_jload($ud.'/orders.json',[]);
      $nextId=(count($orders)?(int)end($orders)['id']+1:1);
      $orders[]=['id'=>$nextId,'product'=>$pname,'pid'=>$pid,'price'=>$price,'status'=>'paid','time'=>time(),'server'=>$servers,'via'=>'wallet'];
      fw_jsave($ud.'/orders.json',$orders);
      ok(['balance'=>$newBal]);
    }

    /* ===== Support (single source of truth) ===== */
    case 'support_load': {
      need_uid($UID);
      $after=(int)($_POST['after']??0);
      $store = fw_chat_migrate_once($UID); // تضمین مسیر اصلی
      $db = fw_jload($store, []);
      $out=[]; foreach($db as $m){ $id=(int)($m['id']??0); if($id>$after) $out[]=$m; }
      ok(['items'=>$out, 'debug'=>fw_chat_debug_info($UID)]);
    }

    case 'support_send': {
      need_uid($UID);
      $text=trim($_POST['text']??''); if($text==='') bad('EMPTY');
      $store = fw_chat_migrate_once($UID);
      $db = fw_jload($store, []);
      $nextId = (count($db)? (int)end($db)['id'] : 0) + 1;
      $db[]=['id'=>$nextId,'ts'=>time(),'from'=>'user','type'=>'text','text'=>$text];
      fw_jsave($store,$db);
      ok(['id'=>$nextId]);
    }

    case 'support_send_file': {
      need_uid($UID);
      if (empty($_FILES['file']) || !is_uploaded_file($_FILES['file']['tmp_name'])) bad('NO_FILE');
      global $UPLOAD_DIR;
      $ext=strtolower(pathinfo($_FILES['file']['name'],PATHINFO_EXTENSION));
      $mime=$_FILES['file']['type']??''; $type=(strpos($mime,'audio')===0)?'audio':'image';
      $name='user_'.$UID.'_'.time().'_'.bin2hex(random_bytes(3)).'.'.$ext;
      $dst=$UPLOAD_DIR.'/'.$name;
      if(!@move_uploaded_file($_FILES['file']['tmp_name'],$dst)) bad('MOVE_FAILED');
      $store = fw_chat_migrate_once($UID);
      $db = fw_jload($store, []);
      $nextId=(count($db)? (int)end($db)['id'] : 0) + 1;
      $db[]=['id'=>$nextId,'ts'=>time(),'from'=>'user','type'=>$type,'url'=>'uploads/'.$name];
      fw_jsave($store,$db);
      ok(['id'=>$nextId,'url'=>'uploads/'.$name,'type'=>$type]);
    }

    /* ابزار دیباگ اختیاری */
    case 'support_debug': {
      need_uid($UID);
      ok(fw_chat_debug_info($UID));
    }

    default: bad('UNKNOWN_ACTION');
  }
}catch(Throwable $e){ bad('SERVER',['detail'=>$e->getMessage()]); }
