<?php


error_reporting(0);

define('API',"8051610396:AAGtHNbK8Qymym_llZ4uv7r5DenWF1wlHJ8"); //توکن

require_once __DIR__.'/config.php';
require_once __DIR__.'/db.php';

/* ---------------- Helpers & Setup ---------------- */
date_default_timezone_set('Asia/Tehran');

function SendMessage($ci, $text, $message_id=null, $reply=null){
    $url  = "https://api.telegram.org/bot".API."/sendMessage?chat_id=".$ci."&text=".urlencode($text);
    if(!is_null($message_id)) $url .= "&reply_to_message_id=".$message_id;
    if(!is_null($reply))      $url .= "&reply_markup=".urlencode($reply);
    @file_get_contents($url);
}
function EditMessageText($ci, $text, $message_id, $reply=null){
    $url  = "https://api.telegram.org/bot".API."/editMessageText?chat_id=".$ci."&message_id=".$message_id."&text=".urlencode($text);
    if(!is_null($reply)) $url .= "&reply_markup=".urlencode($reply);
    @file_get_contents($url);
}
function AnswerCallbackQuery($cbid, $text = "", $alert = false){
    $url  = "https://api.telegram.org/bot".API."/answerCallbackQuery?callback_query_id=".$cbid;
    if($text !== "") $url .= "&text=".urlencode($text);
    if($alert)       $url .= "&show_alert=true";
    @file_get_contents($url);
}
function sendDocument($method, $data=[]){
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL,"https://api.telegram.org/bot".API."/".$method);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $res = curl_exec($ch);
    curl_close($ch);
}
function GetFile($id){
    $data  = "https://api.telegram.org/bot".API."/GetFile?file_id=".$id;
    return @file_get_contents($data);
}
function Upload($id,$dir){
    $api = GetFile($id);
    $js = json_decode($api, true);
    $path = $js['result']['file_path'] ?? null;
    if(!$path) return;
    $link = "https://api.telegram.org/file/bot".API."/".$path;
    @file_put_contents($dir, @file_get_contents($link));
}
function is_admin($id){
    global $sudo;
    return in_array($id, $sudo, true);
}
function Receipt($length = 5){
    $am = array_merge(range('A','Z'), range('a','z'), range(0, 9));
    $o = ""; $c = 0;
    for(; $c < $length; $c++) $o .= $am[array_rand($am)];
    return $o;
}
function deleteFolder($path){
  if(function_exists('exec')){
    @exec("rm -rf ".escapeshellarg($path));
    return !(is_file($path) || is_dir($path));
  } else {
    if(@rmdir($path) || @unlink($path)) return true;
    $glb = glob($path.'/*');
    foreach((array)$glb as $value){
      if(is_dir($value)) deleteFolder($value);
      else if(is_file($value)) @unlink($value);
    }
    return @rmdir($path);
  }
}
function json_load($path, $fallback = []){
    if(!file_exists($path)) return $fallback;
    $s = @file_get_contents($path); $j = @json_decode($s, true);
    return is_array($j) ? $j : $fallback;
}
function json_save($path, $data){
    @mkdir(dirname($path), 0777, true);
    @file_put_contents($path, json_encode($data, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
}
if(!defined('BOT_TOKEN')) define('BOT_TOKEN', API); // هم‌تراز با API

function tg_api($method, $params = []) {
  $url = "https://api.telegram.org/bot".BOT_TOKEN."/".$method;
  $ch = curl_init($url);
  curl_setopt_array($ch,[
    CURLOPT_RETURNTRANSFER=>true,
    CURLOPT_POST=>true,
    CURLOPT_POSTFIELDS=>$params,
    CURLOPT_CONNECTTIMEOUT=>10,
    CURLOPT_TIMEOUT=>20
  ]);
  $res = curl_exec($ch);
  curl_close($ch);
  return json_decode($res,true);
}

/* دانلود و ذخیره آواتار در data/<uid>/avatar.jpg */
function save_user_avatar($uid) {
  @mkdir(__DIR__."/data/$uid", 0777, true);

  // 1) پروفایل‌فوتوها
  $p = tg_api('getUserProfilePhotos', ['user_id'=>$uid, 'limit'=>1]);
  if(!$p || empty($p['ok']) || empty($p['result']['photos'])) {
    return false; // کاربر عکس ندارد
  }

  // 2) بزرگ‌ترین سایز اولین عکس
  $sizes = $p['result']['photos'][0];
  usort($sizes, function($a,$b){
    return ($b['file_size']??0) <=> ($a['file_size']??0);
  });
  $file_id = $sizes[0]['file_id'];

  // 3) مسیر فایل
  $g = tg_api('getFile', ['file_id'=>$file_id]);
  if(!$g || empty($g['ok']) || empty($g['result']['file_path'])) return false;
  $path = $g['result']['file_path'];

  // 4) دانلود
  $fileUrl = "https://api.telegram.org/file/bot".BOT_TOKEN."/".$path;
  $bin = @file_get_contents($fileUrl);
  if(!$bin) return false;

  // 5) ذخیره
  return (bool)@file_put_contents(__DIR__."/data/$uid/avatar.jpg", $bin);
}
/* ---------------- Constants / Dirs ---------------- */
define('DISCOUNT_DB', __DIR__ . '/discounts/codes.json');
define('USER_ORDERS_DIR', __DIR__ . '/user_orders');
@mkdir(dirname(DISCOUNT_DB), 0777, true);
@mkdir(USER_ORDERS_DIR, 0777, true);
if (!is_dir("orders")) @mkdir("orders", 0777, true);

/* ---------------- Payment (ZarinPal) ---------------- */
function zarin($price, $from){
    $MerchantID = '7c9c557d-3ba9-4b94-86f5-6ff7f9a48f67';
    $Amount = $price; // Toman
    $Description = 'پرداخت مبلغ برای VIP';
    $Email = 'mail@amirhajian.com';
    $Mobile = '09355052217';
    $CallbackURL = "http://amirhajian.com/bot/shopfun/verify.php?pay=".$price."&from=".$from;

    if(!class_exists('SoapClient')) return 'ERR: SoapClient not installed';

    $client = new SoapClient('https://www.zarinpal.com/pg/services/WebGate/wsdl', ['encoding' => 'UTF-8']);
    $result = $client->PaymentRequest([
        'MerchantID' => $MerchantID,
        'Amount' => $Amount,
        'Description' => $Description,
        'Email' => $Email,
        'Mobile' => $Mobile,
        'CallbackURL' => $CallbackURL,
    ]);
    if ($result->Status == 100) {
        return ('https://www.zarinpal.com/pg/StartPay/'.$result->Authority);
    } else {
        return 'ERR: '.$result->Status;
    }
}

/* ---------------- Keyboards ---------------- */
$keys = json_encode(['keyboard'=>[
    [['text'=>"فروشگاه🪐"]],
    [['text'=>"حساب کاربری 👤"],['text'=>"شارژ حساب 💸"]]
],'resize_keyboard'=>true], JSON_UNESCAPED_UNICODE);
$back = json_encode(['keyboard'=>[
    [['text'=>"برگشت"]]
],'resize_keyboard'=>true], JSON_UNESCAPED_UNICODE);
$exit = json_encode(['keyboard'=>[
    [['text'=>"خروج"]]
],'resize_keyboard'=>true], JSON_UNESCAPED_UNICODE);

/* ---------------- Updates ---------------- */
$up = json_decode(file_get_contents('php://input'));
$message = $up->message ?? null;
$cal = $up->callback_query ?? null;

$text = $message->text ?? null;
$chat_id = $message->chat->id ?? null;
$message_id = $message->message_id ?? null;
$from_id = $message->from->id ?? null;
$from_username = $message->from->username ?? null;

$contact = $message->contact ?? null;
$phoneNumber = $contact->phone_number ?? null;
$userId = $contact->user_id ?? null;

$doc = $message->document ?? null;
$file_id = $doc->file_id ?? null;
$file_name = $doc->file_name ?? null;

$Data = $cal->data ?? null;
$fromid = $cal->from->id ?? null;
$chatid = $cal->message->chat->id ?? null;
$messageid = $cal->message->message_id ?? null;

/* ---------------- Admins ---------------- */
$sudo = [5004164650,7167180963,0000]; // ادمینا
$admin_id = 7167180963;               // ادمین اصلی
$admin = "Fun_Support_org";

/* ---------------- Users & Files ---------------- */
$rec = Receipt();
if(!is_file("users.txt")){touch("users.txt");}
if(!is_dir("data")){mkdir("data");}
$user_list_raw = (string)@file_get_contents("users.txt");
$users = array_filter(array_map('trim', explode("\n", $user_list_raw))); // خطوط تمیز
$from_id_str = (string)$from_id; // برای مقایسه‌ی دقیق با in_array
$last = @file_get_contents("data/$from_id/last.txt");
$coin = @file_get_contents("data/$from_id/price.txt");
$phone = @file_get_contents("data/$from_id/phone.txt");
$step = @file_get_contents("data/$from_id/step.txt");
$steamid = @file_get_contents("data/$from_id/steamid.txt");
$cat = @file_get_contents("data/$from_id/receipt.txt");

/* ---------------- Panel keyboard (extended) ---------------- */
$panel = json_encode(['keyboard'=>[
    [['text'=>"آمار"],['text'=>"محصولات"]],
    [['text'=>"افزودن محصول"],['text'=>"حذف محصول"]],
    [['text'=>"افزودن کد تخفیف"],['text'=>"لیست کدهای تخفیف"]],
    [['text'=>"حذف کد تخفیف"],['text'=>"API"]],
    [['text'=>"برگشت"]]
],'resize_keyboard'=>true], JSON_UNESCAPED_UNICODE);
////
// بعد از: $up = json_decode(file_get_contents('php://input'));
@mkdir(__DIR__.'/runtime', 0777, true);
@file_put_contents(__DIR__.'/runtime/last_update.txt', time());

/* ============================================================
 * Start / Main Menu
 * ============================================================ */
if (preg_match('/^\/start$/i', (string)$text)) {
 save_user_avatar($from_id);
    // اگر در users.txt نبود، اضافه‌اش کن (با نوع رشته)
    if (!in_array($from_id_str, $users, true)) {
        $f = fopen('users.txt','a');
        fwrite($f, $from_id_str . "\n");
        fclose($f);
    }

    // پوشه‌ی کاربر اگر نیست، بساز
    if (!is_dir("data/$from_id")) {
        @mkdir("data/$from_id", 0777, true);
    }

    // فایل‌ها فقط اگر وجود ندارند ساخته شوند (Overwrite ممنوع)
    if (!file_exists("data/$from_id/last.txt"))    @file_put_contents("data/$from_id/last.txt", "");
    if (!file_exists("data/$from_id/price.txt"))   @file_put_contents("data/$from_id/price.txt", 0);
    if (!file_exists("data/$from_id/step.txt"))    @file_put_contents("data/$from_id/step.txt", "none");
    if (!file_exists("data/$from_id/phone.txt"))   @file_put_contents("data/$from_id/phone.txt", "");
    if (!file_exists("data/$from_id/steamid.txt")) @file_put_contents("data/$from_id/steamid.txt", "");

    // پیام خوش‌آمد
    $answer = "🪐 به Fun World خوش اومدی 🪐  
اینجا دنیای جذاب سرویس‌های VIP سرور CS2 ماست 🎮🔥  

🔰 توی این ربات می‌تونی:  
✅ مشاهده لیست قیمت‌ها و لول‌های VIP  
✅ آشنایی با امکانات هر Level  
✅ خرید اکانت VIP یا ADMIN  
✅ پیگیری و تمدید سرویس  

⚡FuN-ZoNe 🤝 FuN-CitY⚡  

برای شروع یکی از گزینه‌های منو رو انتخاب کن 👇  
هرگونه سوال و پشتیبانی:  
📩 @Fun_Support_org";
    SendMessage($chat_id,$answer,$message_id,$keys);
}


/* ---------------- Back: reset step & temp discount ---------------- */
elseif($text == "برگشت"){
    @file_put_contents("data/$from_id/step.txt","none");
    @unlink("data/$from_id/pending_pid.txt");
    @unlink("data/$from_id/discount.json");
    SendMessage($chat_id,"به منوی اصلی بازگشتید.",$message_id,$keys);
}

/* ---------------- Account ---------------- */
elseif($text == "حساب کاربری 👤"){
    $steamid_show = trim(@file_get_contents("data/$from_id/steamid.txt"));
    if($steamid_show == "") $steamid_show = "ثبت نشده";
    $answer = "حساب کاربری شما :\nپول شما : $coin تومان\nشناسه کاربری : $from_id\nاستیم آیدی شما : $steamid_show";
    $kb = json_encode(['inline_keyboard'=>[
        [['text'=>"✏️ تغییر استیم آیدی",'callback_data'=>"change_steamid_$from_id"]],
        [['text'=>"🛒 خریدهای من",'callback_data'=>"my_orders"]],
    ]], JSON_UNESCAPED_UNICODE);
    SendMessage($chat_id,$answer,$message_id,$kb);
}

/* ---- Change SteamID (callback) ---- */
elseif(preg_match('/^change_steamid_(\d+)$/',$Data,$m)){
    $uid = $m[1];
    if($uid == $fromid){
        @file_put_contents("data/$uid/step.txt","changesteamid");
        EditMessageText($chatid,"✏️ لطفاً استیم آیدی جدید خود را ارسال کنید:",$messageid,null);
    } else {
        AnswerCallbackQuery($cal->id,"این دکمه برای شما نیست!",true);
    }
}
/* ---- Save new SteamID ---- */
elseif($step == "changesteamid"){
    $newid = trim((string)$text);
    if($newid != ""){
        @file_put_contents("data/$from_id/steamid.txt",$newid);
        @file_put_contents("data/$from_id/step.txt","none");
        SendMessage($chat_id,"✅ استیم آیدی جدید شما ذخیره شد:\n🎮 $newid",$message_id,$keys);
    } else {
        SendMessage($chat_id,"❌ لطفاً استیم آیدی معتبر وارد کنید.",$message_id,null);
    }
}

/* ---------------- Charge ---------------- */
elseif($text == "شارژ حساب 💸"){
    if(trim($phone) == ""){
        $answer = "لطفا حساب خود را تایید کنید به دلیل مسائل امنیتی فقط با دکمه زیر";
        $share = json_encode(['keyboard'=>[
            [['text'=>"اشتراک شماره",'request_contact'=>true]],
            [['text'=>"برگشت"]]
        ],'resize_keyboard'=>true], JSON_UNESCAPED_UNICODE);
        SendMessage($chat_id,$answer,$message_id,$share);
        @file_put_contents("data/$from_id/step.txt","share");
    } else {
        $answer = "لطفا مبلغی که میخواهید حساب خود را شارژ کنید را به تومان وارد کنید\nمثال : 10000";
        SendMessage($chat_id,$answer,$message_id,$back);
        @file_put_contents("data/$from_id/step.txt","charge");
    }
}

/* ---- Verify phone (share) ---- */
elseif($step == "share" && isset($contact)){
    if(preg_match('/^(?:98|\+98|0098|0)?9[0-9]{9}$/',$phoneNumber)){
        if($from_id == $userId){
            @file_put_contents("data/$from_id/phone.txt","+".$phoneNumber);
            SendMessage($chat_id,"✅ شماره شما تایید شد.\n\nلطفا استیم آیدی خود را وارد کنید:",$message_id,null);
            @file_put_contents("data/$from_id/step.txt","steamid");
        } else {
            SendMessage($chat_id,"❌ لطفا از شماره تلفن خود استفاده کنید نه شخص دیگری.",$message_id,$back);
        }
    } else {
        SendMessage($chat_id,"❌ لطفا فقط از شماره کشور ایران استفاده کنید: 98",$message_id,$back);
    }
}
/* ---- Save steamid after phone ---- */
elseif($step == "steamid"){
    $sid = trim((string)$text);
    if($sid != ""){
        @file_put_contents("data/$from_id/steamid.txt",$sid);
        @file_put_contents("data/$from_id/step.txt","none");
        SendMessage($chat_id,"✅ استیم آیدی شما ذخیره شد.\nحالا می‌تونید دوباره برای شارژ اقدام کنید.",$message_id,$keys);
    } else {
        SendMessage($chat_id,"❌ لطفا استیم آیدی معتبر وارد کنید.",$message_id,null);
    }
}
/* ---- Charge amount ---- */
elseif($step == "charge"){
    $amt = (int)$text;
    if($amt >= 10000 && $amt <= 200000){
        SendMessage($chat_id,"در حال ساخت لینک پرداخت برای شما صبور باشید....",$message_id,null);
        $link = zarin($amt,$from_id);
        $charge = json_encode(['inline_keyboard'=>[
            [['text'=>"پرداخت کنید",'url'=>$link]]
        ]], JSON_UNESCAPED_UNICODE);
        SendMessage($chat_id,"لینک پرداخت شما ساخته شد با دکمه زیر پرداخت کنید",$message_id,$charge);
        @file_put_contents("data/$from_id/step.txt","none");
    } else {
        SendMessage($chat_id,"لطفا مبلغ را بین 10000 تومان و 200000 تومان وارد کنید",$message_id,$back);
    }
}

/* ---------------- User Orders List (inline) ---------------- */
elseif($Data == "my_orders"){
    $uid = $fromid;
    $uo  = json_load(USER_ORDERS_DIR."/$uid.json", []);
    AnswerCallbackQuery($cal->id);
    if(empty($uo)){
        SendMessage($chatid,"📭 هنوز خریدی ثبت نکرده‌اید.",null,null);
    } else {
        $buttons = [];
        $n = count($uo);
        $start = max(0, $n - 10);
        for($i=$n-1; $i>= $start; $i--){
            $oid = $uo[$i]['id']; $title = "خرید ".($i+1)." - ".$uo[$i]['product'];
            $buttons[] = [['text'=>$title,'callback_data'=>"my_order_$oid"]];
        }
        $kb = json_encode(['inline_keyboard'=>$buttons], JSON_UNESCAPED_UNICODE);
        SendMessage($chatid,"🛒 تاریخچه خرید شما (۱۰ مورد آخر):",null,$kb);
    }
}
elseif(preg_match('/^my_order_(.+)$/',$Data,$m)){
    $oid = $m[1];
    $file = "orders/$oid.json";
    AnswerCallbackQuery($cal->id);
    if(file_exists($file)){
        $d = json_decode(@file_get_contents($file), true);
        if($d){
            $statusText = ($d['status']=="approved" ? "✔️ تایید شده" : ($d['status']=="incomplete" ? "⛔ ناقص" : "⏳ در انتظار"));
            $created = $d['created_at'] ?? @filemtime($file);
            $txt = "🧾 جزئیات خرید:\n\n"
                 . "📦 محصول: {$d['product_id']}\n"
                 . "💰 مبلغ: {$d['price']}\n"
                 . "🖥 سرور: {$d['server']}\n"
                 . "📅 تاریخ: ".date("Y-m-d H:i", $created)."\n"
                 . "وضعیت: $statusText";
            SendMessage($chatid,$txt,null,null);
        }
    } else {
        SendMessage($chatid,"این سفارش دیگر موجود نیست.",null,null);
    }
}

/* ============================================================
 * فروشگاه: انتخاب سرور → دسته‌ها → محصول → نهایی کردن خرید
 * ============================================================ */
$SERVER_LABELS = [
    "1"   => "FuN - CitY⚡️",
    "2"   => "⚡️FuN-ZoNe",
    "1+2" => "هر دو سرور (۲× قیمت)",
];
function fw_label($id){
    global $SERVER_LABELS;
    return $SERVER_LABELS[$id] ?? $id;
}

/* ---- helper: do purchase ---- */
if (!function_exists('fw_do_purchase')) {
function fw_do_purchase($uid, $chat_id_to_reply, $pid, $server){
    global $admin_id, $admin, $cal;

    if(!is_dir("category/$pid")){
        SendMessage($chat_id_to_reply,"چنین محصولی موجود نیست!",null,null);
        return;
    }
    $price = (int)@file_get_contents("category/$pid/price.txt");
    $fnm   = @file_get_contents("category/$pid/name.txt"); if(!$fnm) $fnm = $pid;

    // موجودی
    $coin_file = "data/$uid/price.txt";
    $coin = file_exists($coin_file) ? (int)trim(@file_get_contents($coin_file)) : 0;

    // قیمت نهایی (دو سرور → ۲×)
    $multiplier = ($server === "1+2") ? 2 : 1;
    $finalPrice = $price * $multiplier;

    // تخفیف ذخیره‌شده برای کاربر (با چک سرور)
    $udisc = json_load("data/$uid/discount.json", []);
    if(!empty($udisc['code'])){
        $db = json_load(DISCOUNT_DB, []);
        $code = $udisc['code'];
        if(isset($db[$code])){
            $row = $db[$code];
            $active = !empty($row['is_active']);
            $notExpired = (empty($row['expire_at']) || $row['expire_at'] >= time());
            $allowed = !empty($row['servers']) ? $row['servers'] : ['1','2','1+2'];
            $okServer = in_array($server, $allowed, true);
            if($active && $notExpired && $okServer){
                $p = max(1, min(90, (int)$row['percent']));
                $finalPrice = (int)floor($finalPrice * (100 - $p) / 100);
            } else {
                SendMessage($chat_id_to_reply,"ℹ️ توجه: کد تخفیف اعمال نشد (نامعتبر/منقضی/ناسازگار با سرور).",null,null);
            }
        }
    }

    if($finalPrice > $coin){
        SendMessage($chat_id_to_reply,"موجودی حساب شما کافی نیست ❌\nلطفاً حساب کاربری خود را شارژ کنید 💸",null,null);
        return;
    }

    // کم‌کردن موجودی
    @file_put_contents($coin_file, $coin - $finalPrice);

    // ساخت سفارش
    @mkdir("orders", 0777, true);
    $oid = $uid . "_" . $pid . "_" . time();

    $steamid = trim((string)@file_get_contents("data/$uid/steamid.txt"));
    $phone   = trim((string)@file_get_contents("data/$uid/phone.txt"));
    $uname   = ($cal && isset($cal->from->username) && $cal->from->username != '') ? "@".$cal->from->username : "-";

    $orderData = [
        "id"           => $oid,
        "created_at"   => time(),
        "expires_at"   => time() + 30*86400, // ۳۰ روز
        "status"       => "pending",
        "buyer_id"     => $uid,
        "buyer_chat"   => $chat_id_to_reply,
        "product_id"   => $fnm,     // نام نمایشی
        "product_code" => $pid,     // کد واقعی محصول
        "price"        => $finalPrice,
        "steamid"      => $steamid !== '' ? $steamid : "-",
        "phone"        => $phone   !== '' ? $phone   : "-",
        "username"     => $uname,
        "server"       => $server
    ];
    @file_put_contents("orders/$oid.json", json_encode($orderData, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));

    // آرشیو خرید کاربر
    $uo_path = USER_ORDERS_DIR . "/$uid.json";
    $uo = json_load($uo_path, []);
    $uo[] = [
        'id'=>$orderData['id'],
        'time'=>$orderData['created_at'],
        'product'=>$orderData['product_id'],
        'price'=>$orderData['price'],
        'server'=>$orderData['server'],
        'status'=>$orderData['status']
    ];
    json_save($uo_path, $uo);

    // پیام به خریدار
    $msg = "ممنون بابت خرید شما 🤍\nسفارش شما ثبت و به ادمین ارسال شد ✅\n🖥 سرور: {$orderData['server']}\n💰 مبلغ: {$orderData['price']}\n👾 هرگونه سوال یا مشکل: @$admin";
    SendMessage($chat_id_to_reply,$msg,null,null);

    // پیام به ادمین
    $funworld = "🛒 سفارش جدید ثبت شد\n\n"
              . "📦 محصول: {$orderData['product_id']}\n"
              . "💰 مبلغ: {$orderData['price']}\n"
              . "🖥 سرور: ".fw_label($orderData['server'])."\n"
              . "👤 خریدار: {$orderData['buyer_id']} | {$orderData['username']}\n"
              . "📞 تلفن: {$orderData['phone']}\n"
              . "🆔 استیم آیدی: {$orderData['steamid']}\n"
              . "وضعیت: ⏳ در انتظار تایید";
    $adminKb = json_encode(['inline_keyboard'=>[
        [['text'=>"✅ تایید خرید",'callback_data'=>"order_ok_{$oid}"]],
        [['text'=>"✏️ ویرایش سفارش",'callback_data'=>"order_edit_{$oid}"]],
    ]], JSON_UNESCAPED_UNICODE);
    SendMessage($admin_id,$funworld,null,$adminKb);

    // اگر کد تخفیف استفاده شد: uses++ و پاک کردن تخفیف موقت
    if(!empty($udisc['code'])){
        $db = json_load(DISCOUNT_DB, []);
        if(isset($db[$udisc['code']])){
            $db[$udisc['code']]['uses'] = (int)$db[$udisc['code']]['uses'] + 1;
            json_save(DISCOUNT_DB, $db);
        }
        @unlink("data/$uid/discount.json");
    }
}}
/* ---- Render order for admin ---- */
if (!function_exists('fw_render_order_text')) {
function fw_render_order_text($data, $prefix = ""){
    $statusText = ($data['status']=="approved" ? "✔️ تایید شده"
                : ($data['status']=="incomplete" ? "⛔ ناقص" : "⏳ در انتظار تایید"));
    $uname  = $data['username'] ?? "-";
    $server = $data['server'] ?? "-";
    $txt = ($prefix ? $prefix."\n\n" : "")
         . "📦 محصول: {$data['product_id']}\n"
         . "💰 مبلغ: {$data['price']}\n"
         . "🖥 سرور: {$server}\n"
         . "👤 خریدار: {$data['buyer_id']} | {$uname}\n"
         . "📞 تلفن: {$data['phone']}\n"
         . "🆔 استیم آیدی: {$data['steamid']}\n"
         . "وضعیت: {$statusText}";
    return $txt;
}}
if (!function_exists('fw_admin_kb_default')) {
function fw_admin_kb_default($oid, $status){
    $okBtn = ($status==="approved")
        ? ['text'=>"✔️ تایید شده",'callback_data'=>"noop"]
        : ['text'=>"✅ تایید خرید",'callback_data'=>"order_ok_{$oid}"];
    $kb = ['inline_keyboard'=>[
        [$okBtn],
        [['text'=>"✏️ ویرایش سفارش",'callback_data'=>"order_edit_{$oid}"]],
    ]];
    return json_encode($kb, JSON_UNESCAPED_UNICODE);
}}
if (!function_exists('fw_admin_kb_edit')) {
function fw_admin_kb_edit($oid, $status){
    $okText   = ($status==="approved"   ? "✔️ تایید سفارش" : "تایید سفارش");
    $badText  = ($status==="incomplete" ? "✔️ سفارش ناقص"  : "سفارش ناقص");
    $kb = ['inline_keyboard'=>[
        [['text'=>$okText,  'callback_data'=>"order_set_ok_{$oid}"]],
        [['text'=>$badText, 'callback_data'=>"order_set_bad_{$oid}"]],
        [['text'=>"↩️ برگشت",'callback_data'=>"order_back_{$oid}"]],
    ]];
    return json_encode($kb, JSON_UNESCAPED_UNICODE);
}}

/* ---- Shop Step 1: choose server ---- */
if($text == "فروشگاه🪐"){
    $srvKb = json_encode(['inline_keyboard'=>[
        [['text'=>"🎮 FuN-CitY⚡️",'callback_data'=>"shop_srv_pick_1"]],
        [['text'=>"🎮 FuN-ZoNe⚡️",'callback_data'=>"shop_srv_pick_2"]],
        [['text'=>"🎮 هر دو سرور (۲× قیمت)",'callback_data'=>"shop_srv_pick_both"]],
    ]], JSON_UNESCAPED_UNICODE);
    SendMessage($chat_id,"به فروشگاه Fun World🪐 خوش اومدی\nاول انتخاب کن خریدت برای کدوم سرور باشه:",$message_id,$srvKb);
}

/* ---- Shop Step 2: save server & show categories ---- */
elseif(preg_match('/^shop_srv_pick_(1|2)$/si',$Data,$m) || $Data == "shop_srv_pick_both"){
    $server = ($Data == "shop_srv_pick_both") ? "1+2" : $m[1];
    $uid = $fromid ?: $from_id;
    @mkdir("data/$uid", 0777, true);
    @file_put_contents("data/$uid/server.txt", $server);

    $dir = array_diff(@scandir('category/'),['.','..']);
    if(!empty($dir)){
        $key = [];
        foreach($dir as $value){
            if(is_dir("category/$value")){
                $get = @file_get_contents("category/$value/name.txt");
                if(!$get) $get = $value;
                $key[] = [['text'=>$get,'callback_data'=>"id_$value"]];
            }
        }
        EditMessageText($chatid,"سرور انتخابی: {$server}\nحالا آیتم موردنظر رو انتخاب کن:",$messageid, json_encode(['inline_keyboard'=>$key], JSON_UNESCAPED_UNICODE));
    } else {
        EditMessageText($chatid,"محصولی برای نمایش وجود ندارد.",$messageid,null);
    }
}

/* ---- Shop Step 3: show product (one button: finalize) + discount button ---- */
elseif(preg_match('/^id_(.+)$/si',$Data,$mm)){
    $pid   = $mm[1];
    $info  = @file_get_contents("category/$pid/info.txt");
    $price = @file_get_contents("category/$pid/price.txt");
    $name  = @file_get_contents("category/$pid/name.txt");
    if($name === false)  $name  = $pid;
    if($price === false) $price = "نامشخص";
    if($info === false)  $info  = "—";

    $uid    = $fromid ?: $from_id;
    $server = trim((string)@file_get_contents("data/$uid/server.txt")); if($server === '') $server = '—';

    $answer = "📍 آیتم: $name\n\n📖 توضیحات:\n$info\n\n💰 قیمت پایه: $price\n🖥 سرور انتخابی: $server\n".($server==="1+2" ? "⚠️ برای هر دو سرور، مبلغ نهایی ۲× خواهد شد.\n" : "");

    $kb = json_encode(['inline_keyboard'=>[
        [['text'=>"🛒 نهایی کردن خرید",'callback_data'=>"buy_final_$pid"]],
        [['text'=>"🎟 کد تخفیف دارم",'callback_data'=>"disc_enter_$pid"]],
        [['text'=>"🔄 تغییر سرور",'callback_data'=>"shop_srv_change"]],
        [['text'=>"📂 برگشت به لیست",'callback_data'=>"shop_back"]],
    ]], JSON_UNESCAPED_UNICODE);
    EditMessageText($chatid,$answer,$messageid,$kb);
}

/* ---- change server ---- */
elseif($Data == "shop_srv_change"){
    $srvKb = json_encode(['inline_keyboard'=>[
        [['text'=>"🎮 FuN-CitY⚡️",'callback_data'=>"shop_srv_pick_1"]],
        [['text'=>"🎮 FuN-ZoNe⚡️",'callback_data'=>"shop_srv_pick_2"]],
        [['text'=>"🎮 هر دو سرور (۲× قیمت)",'callback_data'=>"shop_srv_pick_both"]],
        [['text'=>"📂 برگشت به لیست",'callback_data'=>"shop_back"]],
    ]], JSON_UNESCAPED_UNICODE);
    EditMessageText($chatid,"سرور جدید را انتخاب کن:",$messageid,$srvKb);
}

/* ---- back to categories ---- */
elseif($Data == "shop_back"){
    $uid    = $fromid ?: $from_id;
    $server = trim((string)@file_get_contents("data/$uid/server.txt")); if($server === '') $server = '—';
    $dir = array_diff(@scandir('category/'),['.','..']);
    if(!empty($dir)){
        $key = [];
        foreach($dir as $value){
            if(is_dir("category/$value")){
                $get = @file_get_contents("category/$value/name.txt");
                if(!$get) $get = $value;
                $key[] = [['text'=>$get,'callback_data'=>"id_$value"]];
            }
        }
        EditMessageText($chatid,"سرور انتخابی: {$server}\nلطفاً آیتم موردنظر را انتخاب کن:",$messageid, json_encode(['inline_keyboard'=>$key], JSON_UNESCAPED_UNICODE));
    } else {
        EditMessageText($chatid,"محصولی برای نمایش وجود ندارد.",$messageid,null);
    }
}

/* ---- finalize buy (respect chosen server) ---- */
elseif(preg_match('/^buy_final_(.+)$/si',$Data,$m)){
    $pid = $m[1];
    $uid = $fromid ?: $from_id;
    $buyer_chat = $chatid;

    $server = trim((string)@file_get_contents("data/$uid/server.txt"));
    if($server === '' || !in_array($server, ["1","2","1+2"], true)){
        $srvKb = json_encode(['inline_keyboard'=>[
            [['text'=>"🎮 FuN-CitY⚡️",'callback_data'=>"shop_srv_pick_1"]],
            [['text'=>"🎮 FuN-ZoNe⚡️",'callback_data'=>"shop_srv_pick_2"]],
            [['text'=>"🎮 هر دو سرور (۲× قیمت)",'callback_data'=>"shop_srv_pick_both"]],
        ]], JSON_UNESCAPED_UNICODE);
        EditMessageText($chatid,"لطفاً سرور را انتخاب کنید.",$messageid,$srvKb);
        return;
    }
    fw_do_purchase($uid, $buyer_chat, $pid, $server);
    EditMessageText($chatid,"✅ سفارش شما ثبت شد.\n🖥 سرور: $server",$messageid,null);
}

/* ---- Discount: enter (callback) ---- */
elseif(preg_match('/^disc_enter_(.+)$/si',$Data,$m)){
    $pid = $m[1];
    $uid = $fromid ?: $from_id;
    @file_put_contents("data/$uid/step.txt","enter_discount");
    @file_put_contents("data/$uid/pending_pid.txt",$pid);
    AnswerCallbackQuery($cal->id);
    $cancelKb = json_encode(['inline_keyboard'=>[
        [['text'=>"❌ لغو",'callback_data'=>"disc_cancel"]]
    ]], JSON_UNESCAPED_UNICODE);
    EditMessageText($chatid,"🎟 لطفاً کد تخفیف را ارسال کنید.\nبرای لغو: «لغو» یا /cancel",$messageid,$cancelKb);
}
elseif($Data == "disc_cancel"){
    $uid = $fromid ?: $from_id;
    @unlink("data/$uid/pending_pid.txt");
    @unlink("data/$uid/discount.json");
    @file_put_contents("data/$uid/step.txt","none");
    AnswerCallbackQuery($cal->id, "لغو شد");
    EditMessageText($chatid,"❌ ورود کد تخفیف لغو شد.",$messageid,null);
}
/* ---- Discount: text input step ---- */
elseif($step == "enter_discount"){
    $uid = $from_id;
    $msg = trim((string)$text);

    if($msg === "لغو" || $msg === "/cancel"){
        @unlink("data/$uid/pending_pid.txt");
        @unlink("data/$uid/discount.json");
        @file_put_contents("data/$uid/step.txt","none");
        SendMessage($chat_id,"❌ ورود کد تخفیف لغو شد.",$message_id,$keys);
        return;
    }
    $mainBtns = ["فروشگاه🪐","حساب کاربری 👤","شارژ حساب 💸","برگشت","خروج"];
    if(in_array($msg, $mainBtns, true)){
        @unlink("data/$uid/pending_pid.txt");
        @file_put_contents("data/$uid/step.txt","none");
        return;
    }
    if(!preg_match('/^[A-Za-z0-9._-]{3,30}$/', $msg)){
        SendMessage($chat_id,"❌ فرمت کد معتبر نیست.\nمثال: FUN30\nبرای لغو: «لغو» یا /cancel",$message_id,null);
        return;
    }

    $code = strtoupper($msg);
    $db   = json_load(DISCOUNT_DB, []);
    $pid  = trim((string)@file_get_contents("data/$uid/pending_pid.txt"));
    if(!$pid){
        SendMessage($chat_id,"سشن نامعتبر. دوباره داخل صفحه محصول بزن «🎟 کد تخفیف دارم».",$message_id,null);
        @file_put_contents("data/$uid/step.txt","none");
        return;
    }
    if(!isset($db[$code])){
        SendMessage($chat_id,"❌ کد نامعتبر است. دوباره تلاش کنید یا «لغو» بفرستید.",$message_id,null);
        return;
    }
    $row = $db[$code];
    if(empty($row['is_active'])){ SendMessage($chat_id,"❌ این کد غیرفعال است.",$message_id,null); return; }
    if(!empty($row['expire_at']) && $row['expire_at'] < time()){ SendMessage($chat_id,"❌ اعتبار کد به پایان رسیده.",$message_id,null); return; }

    // چک سرور انتخابی فعلی
    $serverSel = trim((string)@file_get_contents("data/$uid/server.txt"));
    if($serverSel === ''){ SendMessage($chat_id,"اول سرور را انتخاب کنید، سپس کد تخفیف را وارد نمایید.",$message_id,null); return; }
    $allowed = !empty($row['servers']) ? $row['servers'] : ['1','2','1+2'];
    if(!in_array($serverSel, $allowed, true)){
        SendMessage($chat_id,"❌ این کد برای سرور انتخابی شما معتبر نیست.\nسرورهای مجاز: ".implode(', ',$allowed),$message_id,null);
        return;
    }

    json_save("data/$uid/discount.json", ['code'=>$code,'percent'=>(int)$row['percent']]);
    @unlink("data/$uid/pending_pid.txt");
    @file_put_contents("data/$uid/step.txt","none");
    SendMessage($chat_id,"✅ کد با موفقیت ثبت شد. هنگام «نهایی کردن خرید» اعمال می‌شود (٪{$row['percent']}).",$message_id,$keys);
}

/* ============================================================
 * Admin: Order management (approve / edit / back)
 * ============================================================ */

elseif(preg_match('/^order_ok_(.+)$/si',$Data,$m)){
    $oid  = $m[1]; $file = "orders/$oid.json"; AnswerCallbackQuery($cal->id);
    if(file_exists($file)){
        $data = json_decode(@file_get_contents($file), true);
        if($data && $data['status'] !== "approved"){
            $data['status'] = "approved";
            @file_put_contents($file, json_encode($data, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
            $newText = fw_render_order_text($data, "🛒 سفارش تایید شد ✅");
            $newKb   = fw_admin_kb_default($oid, $data['status']);
            EditMessageText($chatid,$newText,$messageid,$newKb);
            SendMessage($data['buyer_chat'],"✅ سفارش شما تایید و تحویل داده شد.\nاز خرید شما از Fun World سپاسگزاریم 🪐",null,null);
        } else {
            $curText = fw_render_order_text($data, "🛒 سفارش تایید شده است");
            $kb = fw_admin_kb_default($oid, $data['status']);
            EditMessageText($chatid,$curText,$messageid,$kb);
        }
    }
}
elseif(preg_match('/^order_edit_(.+)$/si',$Data,$m)){
    $oid  = $m[1]; $file = "orders/$oid.json"; AnswerCallbackQuery($cal->id);
    if(file_exists($file)){
        $data = json_decode(@file_get_contents($file), true);
        if($data){
            $statusText = ($data['status']=="approved"?"✔️ تایید شده":($data['status']=="incomplete"?"⛔ ناقص":"⏳ در انتظار"));
            $txt = "🛠 ویرایش سفارش\n\nشناسه: {$data['id']}\nوضعیت فعلی: {$statusText}";
            $kb  = fw_admin_kb_edit($oid, $data['status']);
            EditMessageText($chatid,$txt,$messageid,$kb);
        }
    }
}
elseif(preg_match('/^order_set_ok_(.+)$/si',$Data,$m)){
    $oid  = $m[1]; $file = "orders/$oid.json"; AnswerCallbackQuery($cal->id);
    if(file_exists($file)){
        $data = json_decode(@file_get_contents($file), true);
        if($data){
            if($data['status'] !== "approved"){
                $data['status'] = "approved";
                @file_put_contents($file, json_encode($data, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
                SendMessage($data['buyer_chat'],"✅ سفارش شما تایید و تحویل داده شد.\nاز خرید شما از Fun World سپاسگزاریم 🪐",null,null);
            }
            $txt = fw_render_order_text($data, "🛒 وضعیت به «تایید شده» تغییر کرد");
            $kb  = fw_admin_kb_default($oid, $data['status']);
            EditMessageText($chatid,$txt,$messageid,$kb);
        }
    }
}
elseif(preg_match('/^order_set_bad_(.+)$/si',$Data,$m)){
    $oid  = $m[1]; $file = "orders/$oid.json"; AnswerCallbackQuery($cal->id);
    if(file_exists($file)){
        $data = json_decode(@file_get_contents($file), true);
        if($data){
            if($data['status'] === "approved"){
                $kb  = fw_admin_kb_edit($oid, $data['status']);
                $txt = "🛠 ویرایش سفارش\n\nشناسه: {$data['id']}\nوضعیت فعلی: ✔️ تایید شده (قابل تغییر نیست)";
                EditMessageText($chatid,$txt,$messageid,$kb);
            } else {
                $data['status'] = "incomplete";
                @file_put_contents($file, json_encode($data, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
                $txt = fw_render_order_text($data, "🛒 وضعیت به «سفارش ناقص» تغییر کرد");
                $kb  = fw_admin_kb_default($oid, $data['status']);
                EditMessageText($chatid,$txt,$messageid,$kb);
            }
        }
    }
}
elseif(preg_match('/^order_back_(.+)$/si',$Data,$m)){
    $oid  = $m[1]; $file = "orders/$oid.json"; AnswerCallbackQuery($cal->id);
    if(file_exists($file)){
        $data = json_decode(@file_get_contents($file), true);
        if($data){
            $txt = fw_render_order_text($data, "🛒 جزئیات سفارش");
            $kb  = fw_admin_kb_default($oid, $data['status']);
            EditMessageText($chatid,$txt,$messageid,$kb);
        }
    }
}

/* ============================================================
 * Admin Panel: Products & Discount Codes
 * ============================================================ */

elseif(preg_match('/^[\/]?(panel|پنل|خروج)$/ui',(string)$text) && is_admin($from_id)){
    SendMessage($chat_id,"🪐عیسی داداش چطوری به پنل مدیریتت خوش اومدی.",$message_id,$panel);
    @file_put_contents("data/$from_id/step.txt","none");
}
elseif($text == "آمار" && is_admin($from_id)){
    $usr = explode("\n",(string)$user);
    $cUser = max(0, count($usr)-1);
    SendMessage($chat_id,"آمار کاربران با احتساب خودتان $cUser نفر است.",$message_id,$panel);
}
elseif($text == "افزودن محصول" && is_admin($from_id)){
    SendMessage($chat_id,"لطفا نام محصول خود را وارد کنید:\nاین نام به جای دکمه استفاده میشود و باید کمتر از 30 کاراکتر باشد\nمثال : نایف باترفللای XD",$message_id,$exit);
    @file_put_contents("data/$from_id/step.txt","product_name");
}
elseif($step == "product_name" && isset($text) && is_admin($from_id)){
    if(mb_strlen($text,'UTF-8') <= 30){
        SendMessage($chat_id,"خب حالا قیمت محصول خود را وارد کنید به تومان مثال : 20000",$message_id,$exit);
        @mkdir("category/$rec");
        @file_put_contents("data/$from_id/step.txt","product_price");
        @file_put_contents("data/$from_id/receipt.txt","$rec");
        @file_put_contents("category/$rec/name.txt","$text");
    } else {
        SendMessage($chat_id,"طول نام بیشتر از 30 کاراکتر است!",$message_id,$exit);
    }
}
elseif($step == "product_price" && isset($text) && is_admin($from_id)){
    if(is_numeric($text)){
        SendMessage($chat_id,"خب حالا توضیحاتی در مورد محصول خود وارد کنید...",$message_id,$exit);
        @file_put_contents("category/$cat/price.txt","$text");
        @file_put_contents("data/$from_id/step.txt","product_info");
    } else {
        SendMessage($chat_id,"لطفا مبلغ را به عدد انگلیسی و به تومان وارد کنید.",$message_id,$exit);
    }
}
elseif($step == "product_info" && isset($text) && is_admin($from_id)){
    SendMessage($chat_id,"رسیدیم به آخرین مرحله لطفا فایل خود را ارسال کنید...",$message_id,$exit);
    @file_put_contents("category/$cat/info.txt","$text");
    @file_put_contents("data/$from_id/step.txt","product_file");
}
elseif($step == "product_file" && isset($doc) && is_admin($from_id)){
    SendMessage($chat_id,"درحال آپلود فایل...",$message_id,$exit);
    @mkdir("category/$cat/file");
    @file_put_contents("category/$cat/file_name.txt","$file_name");
    Upload($file_id,"category/$cat/file/$file_name");
    SendMessage($chat_id,"محصول شما با موفقیت به لیست محصولات اضافه گردید...",$message_id,$exit);
    @file_put_contents("data/$from_id/step.txt","none");
    @file_put_contents("data/$from_id/receipt.txt","");
}
elseif($text == "محصولات" && is_admin($from_id)){
    $dir = @scandir("category"); $diff = array_diff((array)$dir, ['.','..']);
    $out=""; foreach($diff as $value){ if(is_dir("category/".$value)){ $name = @file_get_contents("category/".$value."/name.txt"); $out .= "📖 نام محصول : $name \n 🎫 کد محصول : $value\n➖➖➖➖➖➖➖➖➖\n"; } }
    SendMessage($chat_id,"📍لیست محصولات شما :\n\n".$out,$message_id,$panel);
}
elseif($text == "حذف محصول" && is_admin($from_id)){
    SendMessage($chat_id,"کد محصولی که میخواهید حذف شود را ارسال کنید.\n(این کد را از پنل مدیریت بخش محصولات دریافت کنید)",$message_id,$exit);
    @file_put_contents("data/$from_id/step.txt","delete");
}
elseif($step == "delete" && is_admin($from_id)){
    if(is_dir("category/".$text)){
        SendMessage($chat_id,"درحال انجام عملیات حذف....",$message_id,$exit);
        deleteFolder("category/".$text);
        SendMessage($chat_id,"محصول با کد $text حذف گردید",$message_id,$exit);
        @file_put_contents("data/$from_id/step.txt","none");
    } else {
        SendMessage($chat_id,"چنین محصولی با کد $text یافت نشد.",$message_id,$exit);
    }
}

/* ---------------- Admin: Discount Codes (with server scope) ---------------- */
elseif($text == "افزودن کد تخفیف" && is_admin($from_id)){
    @file_put_contents("data/$from_id/step.txt","disc_code");
    json_save("data/$from_id/disc_tmp.json", []);
    SendMessage($chat_id,"لطفاً متن کد تخفیف را وارد کنید (مثل: FUN30)",$message_id,$exit);
}
elseif($step == "disc_code" && is_admin($from_id)){
    $tmp = json_load("data/$from_id/disc_tmp.json", []);
    $tmp['code'] = strtoupper(trim((string)$text));
    json_save("data/$from_id/disc_tmp.json", $tmp);
    @file_put_contents("data/$from_id/step.txt","disc_percent");
    SendMessage($chat_id,"درصد تخفیف را وارد کنید (۱ تا ۹۰)",$message_id,$exit);
}
elseif($step == "disc_percent" && is_admin($from_id)){
    $p = (int)trim((string)$text);
    if($p<1 || $p>90){ SendMessage($chat_id,"درصد باید بین ۱ تا ۹۰ باشد.",$message_id,$exit); }
    else{
        $tmp = json_load("data/$from_id/disc_tmp.json", []);
        $tmp['percent'] = $p;
        json_save("data/$from_id/disc_tmp.json", $tmp);
        @file_put_contents("data/$from_id/step.txt","disc_days");
        SendMessage($chat_id,"تعداد روز اعتبار را وارد کنید (۰ = نامحدود)",$message_id,$exit);
    }
}
elseif($step == "disc_days" && is_admin($from_id)){
    $days = (int)trim((string)$text);
    $tmp  = json_load("data/$from_id/disc_tmp.json", []);
    $tmp['valid_days'] = $days;
    json_save("data/$from_id/disc_tmp.json", $tmp);

    @file_put_contents("data/$from_id/step.txt","disc_servers");
    $msg = "این کد برای کدام سرورها معتبر است؟\n"
         . "یکی از این‌ها را بفرست:\n"
         . "• 1\n• 2\n• 1+2\n• 1,2 (چندتا با کاما)\n• all (برای همه)";
    SendMessage($chat_id,$msg,$message_id,$exit);
}
elseif($step == "disc_servers" && is_admin($from_id)){
    $inp = trim(mb_strtolower((string)$text,'UTF-8'));
    $servers = [];
    if($inp === "all" || $inp === "۰" || $inp === "0"){
        $servers = ['1','2','1+2'];
    } else {
        $parts = preg_split('/[,\s]+/u', $inp, -1, PREG_SPLIT_NO_EMPTY);
        foreach($parts as $p){
            $p = str_replace(['٬','،'], ',', $p);
            $p = trim($p);
            if(in_array($p, ['1','2','1+2'], true)){ $servers[$p] = true; }
        }
        $servers = array_keys($servers);
    }
    if(empty($servers)){
        SendMessage($chat_id,"فرمت نامعتبر. یکی از مقادیر: 1 | 2 | 1+2 | 1,2 | all",$message_id,$exit);
        return;
    }

    $tmp = json_load("data/$from_id/disc_tmp.json", []);
    $code = $tmp['code'] ?? null;  $p = $tmp['percent'] ?? null;  $days = $tmp['valid_days'] ?? 0;
    if(!$code || !$p){
        SendMessage($chat_id,"داده ناقص است. از ابتدا بسازید.",$message_id,$panel);
        @file_put_contents("data/$from_id/step.txt","none");
        @unlink("data/$from_id/disc_tmp.json");
        return;
    }

    $db  = json_load(DISCOUNT_DB, []);
    $exp = ($days>0) ? (time() + $days*86400) : 0;
    $db[$code] = [
        'percent'   => (int)$p,
        'expire_at' => $exp,
        'is_active' => true,
        'created_at'=> time(),
        'uses'      => 0,
        'servers'   => $servers,
    ];
    json_save(DISCOUNT_DB, $db);

    @file_put_contents("data/$from_id/step.txt","none");
    @unlink("data/$from_id/disc_tmp.json");

    $expText = $exp ? ("تا ".date("Y-m-d H:i",$exp)) : "نامحدود";
    $srvText = implode(', ', $servers);
    SendMessage($chat_id,"✅ کد ثبت شد:\n🔑 $code\n٪$p\n⏳ اعتبار: $expText\n🖥 سرورهای مجاز: $srvText",$message_id,$panel);
}
elseif($text == "لیست کدهای تخفیف" && is_admin($from_id)){
    $db = json_load(DISCOUNT_DB, []);
    if(empty($db)){ SendMessage($chat_id,"هیچ کدی موجود نیست.",$message_id,$panel); }
    else{
        $out = "🎟 لیست کدهای تخفیف:\n\n";
        foreach($db as $code=>$row){
            $exp = ($row['expire_at'] ? date("Y-m-d", $row['expire_at']) : "نامحدود");
            $act = (!empty($row['is_active']) ? "فعال" : "غیرفعال");
            $srv = !empty($row['servers']) ? implode(', ',$row['servers']) : "all";
            $out .= "🔑 $code | ٪{$row['percent']} | ⏳ $exp | $act | استفاده: {$row['uses']} | 🖥 $srv\n";
        }
        SendMessage($chat_id,$out,$message_id,$panel);
    }
}
elseif($text == "حذف کد تخفیف" && is_admin($from_id)){
    @file_put_contents("data/$from_id/step.txt","disc_del");
    SendMessage($chat_id,"کدی که باید حذف شود را وارد کنید (مثل: FUN30)",$message_id,$exit);
}
elseif($step == "disc_del" && is_admin($from_id)){
    $code = strtoupper(trim((string)$text));
    $db = json_load(DISCOUNT_DB, []);
    if(isset($db[$code])){ unset($db[$code]); json_save(DISCOUNT_DB, $db);
        SendMessage($chat_id,"✅ کد $code حذف شد.",$message_id,$panel);
    } else {
        SendMessage($chat_id,"کد یافت نشد.",$message_id,$panel);
    }
    @file_put_contents("data/$from_id/step.txt","none");
}
/* =========================[ API: Admin + Group Auto Reply ]========================= */
/* 1) Config & helpers */
if(!defined('API_DIR')) define('API_DIR', __DIR__ . '/API');
if(!defined('API_DB'))  define('API_DB',  API_DIR . '/defs.json');
@mkdir(API_DIR, 0777, true);

if(!function_exists('api_db_load')){
    function api_db_load(){
        if(!file_exists(API_DB)) return [];
        $j = @json_decode(@file_get_contents(API_DB), true);
        return is_array($j) ? $j : [];
    }
}
if(!function_exists('api_db_save')){
    function api_db_save($arr){
        @file_put_contents(API_DB, json_encode($arr, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
    }
}
if(!function_exists('api_add_or_merge')){
    function api_add_or_merge($key, $replies){
        $db = api_db_load();
        $old = (isset($db[$key]) && is_array($db[$key])) ? $db[$key] : [];
        $merged = array_values(array_unique(array_merge($old, $replies)));
        $db[$key] = $merged;
        api_db_save($db);
    }
}
if(!function_exists('api_delete')){
    function api_delete($key){
        $db = api_db_load();
        if(isset($db[$key])){ unset($db[$key]); api_db_save($db); return true; }
        return false;
    }
}
if(!function_exists('api_list_keys')){
    function api_list_keys(){ return array_keys(api_db_load()); }
}
if(!function_exists('api_get_replies')){
    function api_get_replies($key){
        $db = api_db_load();
        return (isset($db[$key]) && is_array($db[$key])) ? $db[$key] : [];
    }
}
if(!function_exists('api_set_reply_index')){
    function api_set_reply_index($key,$idx,$newText){
        $db = api_db_load();
        if(!isset($db[$key]) || !isset($db[$key][$idx])) return false;
        $db[$key][$idx] = $newText;
        api_db_save($db);
        return true;
    }
}
/* safe base64 for callback_data */
if(!function_exists('enc')){ function enc($s){ return rtrim(strtr(base64_encode($s), '+/', '-_'), '='); } }
if(!function_exists('dec')){ function dec($s){ return base64_decode(strtr($s, '-_', '+/')); } }

/* 2) Local keyboards for API admin */
$api_menu = json_encode(['keyboard'=>[
    [['text'=>"افزودن API"],['text'=>"لیست API"]],
    [['text'=>"↩️ بازگشت به پنل مدیریت"]],
],'resize_keyboard'=>true], JSON_UNESCAPED_UNICODE);

/* 3) API Admin Menu entry */
if($text == "API" && is_admin($from_id)){
    @file_put_contents("data/$from_id/step.txt","none");
    SendMessage($chat_id,"بخش API:\nکلمه‌ها و جواب‌ها برای استفاده در گروه‌ها.",$message_id,$api_menu);
}

/* Back to main admin panel */
elseif($text == "↩️ بازگشت به پنل مدیریت" && is_admin($from_id)){
    @file_put_contents("data/$from_id/step.txt","none");
    SendMessage($chat_id,"به پنل برگشتی.",$message_id,$panel);
}

/* 4) Add API flow */
elseif($text == "افزودن API" && is_admin($from_id)){
    @file_put_contents("data/$from_id/step.txt","api_add_key");
    @file_put_contents("data/$from_id/api_tmp.json", json_encode(['key'=>null,'replies'=>[]], JSON_UNESCAPED_UNICODE));
    SendMessage($chat_id,"لطفاً «نام API» (کلمه محرک) را ارسال کن.\nمثال: سلام",$message_id,$api_menu);
}
elseif($step == "api_add_key" && is_admin($from_id)){
    $key = trim((string)$text);
    if($key === ""){
        SendMessage($chat_id,"❌ نام معتبر نیست. دوباره بفرست.",$message_id,$api_menu);
    } else {
        $tmp = ['key'=>$key,'replies'=>[]];
        @file_put_contents("data/$from_id/api_tmp.json", json_encode($tmp, JSON_UNESCAPED_UNICODE));
        @file_put_contents("data/$from_id/step.txt","api_add_reply");
        SendMessage($chat_id,"حالا «جواب» را بفرست.\nهرچندتا خواستی بفرست؛ وقتی تمام شد «نه» یا /done بزن.",$message_id,$api_menu);
    }
}
elseif($step == "api_add_reply" && is_admin($from_id)){
    $msg = trim((string)$text);
    if($msg === "" ){
        SendMessage($chat_id,"❌ خالیه! جواب بفرست یا «نه» / /done.",$message_id,$api_menu);
    } elseif(in_array($msg, ["نه","خیر","/done"], true)){
        $tmp = json_decode(@file_get_contents("data/$from_id/api_tmp.json"), true);
        if(!$tmp || !$tmp['key'] || empty($tmp['replies'])){
            @file_put_contents("data/$from_id/step.txt","none");
            SendMessage($chat_id,"⛔ چیزی برای ذخیره نبود. به منوی API برگشتی.",$message_id,$api_menu);
        } else {
            api_add_or_merge($tmp['key'], $tmp['replies']);
            @unlink("data/$from_id/api_tmp.json");
            @file_put_contents("data/$from_id/step.txt","none");
            SendMessage($chat_id,"✅ ذخیره شد.\nکلید: {$tmp['key']}\nتعداد جواب: ".count($tmp['replies']),$message_id,$api_menu);
        }
    } else {
        $tmp = json_decode(@file_get_contents("data/$from_id/api_tmp.json"), true);
        if(!$tmp){ $tmp=['key'=>null,'replies'=>[]]; }
        $tmp['replies'][] = $msg;
        @file_put_contents("data/$from_id/api_tmp.json", json_encode($tmp, JSON_UNESCAPED_UNICODE));
        SendMessage($chat_id,"✔️ ثبت شد. جواب دیگری هم می‌خوای؟\nاگر تمام شد «نه» یا /done بفرست.",$message_id,$api_menu);
    }
}

/* 5) List API root (inline) */
elseif($text == "لیست API" && is_admin($from_id)){
    $kb = json_encode(['inline_keyboard'=>[
        [['text'=>"📜 نمایش لیست",'callback_data'=>"api_list_p_1"]],
        [['text'=>"🧹 حذف API",'callback_data'=>"api_del_p_1"]],
        [['text'=>"✏️ ویرایش API",'callback_data'=>"api_edit_p_1"]],
        [['text'=>"↩️ برگشت به API",'callback_data'=>"api_back_menu"], ['text'=>"🔙 بازگشت به پنل",'callback_data'=>"api_back_panel"]],
    ]], JSON_UNESCAPED_UNICODE);
    SendMessage($chat_id,"کدوم بخش از لیست رو می‌خوای؟",$message_id,$kb);
}

/* Inline backs */
elseif($Data == "api_back_menu" && is_admin($fromid)){
    AnswerCallbackQuery($cal->id);
    SendMessage($chatid,"به منوی API برگشتی.",null,$api_menu);
}
elseif($Data == "api_back_panel" && is_admin($fromid)){
    AnswerCallbackQuery($cal->id);
    SendMessage($chatid,"به پنل مدیریت برگشتی.",null,$panel);
}
elseif($Data == "api_close" && is_admin($fromid)){
    AnswerCallbackQuery($cal->id);
    SendMessage($chatid,"بسته شد.", null, null);
}

/* 6) Paged list helpers */
if(!function_exists('api_render_list_page')){
    function api_render_list_page($mode, $page=1){
        // mode: list | del | edit
        $keys = api_list_keys();
        $per = 5;
        $total = count($keys);
        $pages = max(1, (int)ceil(($total ?: 1)/$per));
        $page = max(1, min($pages, (int)$page));
        $start = ($page-1)*$per;
        $slice = array_slice($keys, $start, $per);

        $rows = [];
        foreach($slice as $k){
            if($mode === 'list'){
                $rows[] = [
                    ['text'=>$k, 'callback_data'=>"api_view_".enc($k)],
                    ['text'=>"👁 مشاهده جواب", 'callback_data'=>"api_show_".enc($k)],
                ];
            } elseif($mode === 'del'){
                $rows[] = [
                    ['text'=>$k, 'callback_data'=>"noop"],
                    ['text'=>"❌ حذف", 'callback_data'=>"api_del_do_".enc($k)],
                ];
            } else { // edit
                $rows[] = [
                    ['text'=>$k, 'callback_data'=>"api_edit_pick_".enc($k)],
                    ['text'=>"👁 لیست جواب‌ها", 'callback_data'=>"api_show_".enc($k)],
                ];
            }
        }
        // nav
        $nav = [];
        if($page>1)      $nav[] = ['text'=>"⬅️ قبلی",'callback_data'=>"api_{$mode}_p_".($page-1)];
        if($page<$pages) $nav[] = ['text'=>"➡️ بعدی",'callback_data'=>"api_{$mode}_p_".($page+1)];
        if(!empty($nav)) $rows[] = $nav;

        // bottoms
        $rows[] = [
            ['text'=>"✖️ بستن",'callback_data'=>"api_close"],
            ['text'=>"↩️ برگشت به API",'callback_data'=>"api_back_menu"],
            ['text'=>"🔙 پنل",'callback_data'=>"api_back_panel"],
        ];

        $kb = json_encode(['inline_keyboard'=>$rows], JSON_UNESCAPED_UNICODE);
        $title = ($mode==='list'?"📜 نمایش لیست":"🧹 حذف API");
        if($mode==='edit') $title = "✏️ ویرایش API";
        return [$title." (صفحه $page/$pages)", $kb];
    }
}

/* 7) List paging handlers */
if(preg_match('/^api_list_p_(\d+)$/',$Data,$m) && is_admin($fromid)){
    AnswerCallbackQuery($cal->id);
    list($txt,$kb) = api_render_list_page('list', (int)$m[1]);
    EditMessageText($chatid, $txt, $messageid, $kb);
}
if(preg_match('/^api_del_p_(\d+)$/',$Data,$m) && is_admin($fromid)){
    AnswerCallbackQuery($cal->id);
    list($txt,$kb) = api_render_list_page('del', (int)$m[1]);
    EditMessageText($chatid, $txt, $messageid, $kb);
}
if(preg_match('/^api_edit_p_(\d+)$/',$Data,$m) && is_admin($fromid)){
    AnswerCallbackQuery($cal->id);
    list($txt,$kb) = api_render_list_page('edit', (int)$m[1]);
    EditMessageText($chatid, $txt, $messageid, $kb);
}

/* 8) View replies list / view key */
if(preg_match('/^api_show_(.+)$/',$Data,$m) && is_admin($fromid)){
    AnswerCallbackQuery($cal->id);
    $key = dec($m[1]);
    $reps = api_get_replies($key);
    if(empty($reps)){
        SendMessage($chatid, "برای «$key» جوابی ثبت نشده.", null, null);
    } else {
        $txt = "جواب‌های «$key»:\n";
        foreach($reps as $i=>$r){ $txt .= ($i+1).") ".$r."\n"; }
        SendMessage($chatid, $txt, null, null);
    }
}
if(preg_match('/^api_view_(.+)$/',$Data,$m) && is_admin($fromid)){
    AnswerCallbackQuery($cal->id);
    $key = dec($m[1]);
    SendMessage($chatid, "کلید: «$key»", null, null);
}

/* 9) Delete one */
if(preg_match('/^api_del_do_(.+)$/',$Data,$m) && is_admin($fromid)){
    AnswerCallbackQuery($cal->id);
    $key = dec($m[1]);
    if(api_delete($key)) SendMessage($chatid, "✅ حذف شد: $key", null, null);
    else                SendMessage($chatid, "❌ پیدا نشد: $key", null, null);
}

/* 10) Edit pick → choose which reply to edit */
if(preg_match('/^api_edit_pick_(.+)$/',$Data,$m) && is_admin($fromid)){
    AnswerCallbackQuery($cal->id);
    $key = dec($m[1]);
    $reps = api_get_replies($key);
    if(empty($reps)){
        SendMessage($chatid, "برای «$key» جوابی ثبت نشده.", null, null);
    } else {
        $rows = [];
        foreach($reps as $i=>$r){
            $rows[] = [
                ['text'=> ($i+1).". ".$r, 'callback_data'=>"noop"],
                ['text'=>"✏️ ویرایش #".($i+1), 'callback_data'=>"api_edit_idx_".enc($key)."_".$i],
            ];
        }
        $rows[] = [
            ['text'=>"↩️ برگشت به API",'callback_data'=>"api_back_menu"],
            ['text'=>"🔙 پنل",'callback_data'=>"api_back_panel"]
        ];
        $kb = json_encode(['inline_keyboard'=>$rows], JSON_UNESCAPED_UNICODE);
        SendMessage($chatid, "ویرایش جواب‌های «$key»:", null, $kb);
    }
}

/* 11) Edit a specific reply → text step */
if(preg_match('/^api_edit_idx_(.+)_(\d+)$/',$Data,$m) && is_admin($fromid)){
    AnswerCallbackQuery($cal->id);
    $key = dec($m[1]); $idx = (int)$m[2];
    @file_put_contents("data/$fromid/step.txt","api_edit_wait");
    @file_put_contents("data/$fromid/api_edit.json", json_encode(['key'=>$key,'idx'=>$idx], JSON_UNESCAPED_UNICODE));
    SendMessage($chatid, "متن جدید برای پاسخ #".($idx+1)." از «$key» را ارسال کن:", null, null);
}
if($step == "api_edit_wait" && is_admin($from_id)){
    $info = json_decode(@file_get_contents("data/$from_id/api_edit.json"), true);
    $new  = trim((string)$text);
    if(!$info || $new === ""){
        SendMessage($chat_id, "❌ نامعتبر. دوباره انجام بده.", $message_id, $api_menu);
    } else {
        if(api_set_reply_index($info['key'], $info['idx'], $new))
            SendMessage($chat_id, "✅ ویرایش شد.", $message_id, $api_menu);
        else
            SendMessage($chat_id, "❌ انجام نشد.", $message_id, $api_menu);
    }
    @unlink("data/$from_id/api_edit.json");
    @file_put_contents("data/$from_id/step.txt","none");
}

/* 12) Auto reply in groups (EXACT MATCH) */
if(isset($message) && isset($message->chat) && isset($message->chat->type)){
    $chat_type = $message->chat->type; // "private" | "group" | "supergroup"
    if(($chat_type === "group" || $chat_type === "supergroup") && !empty($text)){
        $key = trim($text); // EXACT MATCH
        $db = api_db_load();
        if(isset($db[$key]) && is_array($db[$key]) && count($db[$key])>0){
            $rep = $db[$key][array_rand($db[$key])]; // یک جواب تصادفی از بین پاسخ‌ها
            SendMessage($chat_id, $rep, $message_id, null);
        }
    }
}
/* =========================[ /API Section ]========================= */
@file_get_contents('https://amirhajian.com/bot/shopfun/heartbeat.php?k=8585');

?>
