<?php
// Update bot heartbeat safely
error_reporting(0);
date_default_timezone_set('Asia/Tehran');

$secret = '8585'; // یک shared secret ساده
if (!isset($_GET['k']) || $_GET['k'] !== $secret) { http_response_code(403); exit('forbidden'); }

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

function db(): PDO {
  static $pdo=null;
  if ($pdo instanceof PDO) return $pdo;
  if (isset($GLOBALS['pdo']) && $GLOBALS['pdo'] instanceof PDO) { $pdo=$GLOBALS['pdo']; return $pdo; }
  $dsn  = defined('DB_DSN')  ? DB_DSN  : ("mysql:host=".(DB_HOST??'localhost').";dbname=".(DB_NAME??'funworld').";charset=utf8mb4");
  $user = defined('DB_USER') ? DB_USER : (defined('DB_USERNAME') ? DB_USERNAME : 'root');
  $pass = defined('DB_PASS') ? DB_PASS : (defined('DB_PASSWORD') ? DB_PASSWORD : '');
  $pdo = new PDO($dsn,$user,$pass,[PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION]);
  return $pdo;
}

try{
  db()->exec("CREATE TABLE IF NOT EXISTS bot_heartbeat (
    id TINYINT PRIMARY KEY,
    last_seen INT NULL,
    start_time INT NULL,
    version VARCHAR(32) NULL
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
  $now = time();
  $row = db()->query("SELECT id FROM bot_heartbeat WHERE id=1")->fetch();
  if(!$row){
    $st=db()->prepare("INSERT INTO bot_heartbeat(id,last_seen,start_time,version) VALUES(1,?,?,?)");
    $st->execute([$now,$now,'1.0']);
  }else{
    db()->prepare("UPDATE bot_heartbeat SET last_seen=? WHERE id=1")->execute([$now]);
  }
  echo 'ok';
}catch(Throwable $e){
  http_response_code(500); echo 'err';
}
