<?php
// bot/shopfun/funs/mini_api.php
session_start();
require_once __DIR__.'/auth.php';

// تلگرام
if(!defined('BOT_TOKEN')){
  // اگر در config.php داری، حذف کن؛ اگر نداری اینجا پرش کن
  define('BOT_TOKEN', '8051610396:AAGtHNbK8Qymym_llZ4uv7r5DenWF1wlHJ8'); // مثل "8051610:XXXX"
}
function tg_send($chat_id,$text){
  if(!BOT_TOKEN || !$chat_id) return;
  $url="https://api.telegram.org/bot".BOT_TOKEN."/sendMessage?chat_id=".$chat_id."&text=".urlencode($text);
  @file_get_contents($url);
}

header('Content-Type: application/json; charset=utf-8');
if(!is_admin()){ echo json_encode(['ok'=>0,'err'=>'unauthorized']); exit; }

$act = $_POST['act'] ?? $_GET['act'] ?? '';

/* ============ Admin management (sudo only) ============ */
if($act==='admin_list' && is_sudo()){
  echo json_encode(['ok'=>1,'items'=>array_values(array_map(function($a){ return ['username'=>$a['username'],'name'=>$a['name']]; }, read_admins()))]);
  exit;
}
if($act==='admin_add' && is_sudo()){
  $u=trim($_POST['username']??''); $p=trim($_POST['pass']??''); $n=trim($_POST['name']??''); $c=trim($_POST['chat_id']??''); $tg=trim($_POST['tg']??'');
  if($u===''||$p===''){ echo json_encode(['ok'=>0,'err'=>'empty']); exit; }
  $ok = add_admin($u,$p,$n,$c,$tg);
  echo json_encode(['ok'=>$ok?1:0]); exit;
}
if($act==='admin_del' && is_sudo()){
  $list = $_POST['list'] ?? [];
  $ok = delete_admins($list);
  echo json_encode(['ok'=>1,'deleted'=>$ok]); exit;
}
if($act==='admin_change_pass'){ // ادمین می‌تواند رمز خودش را عوض کند
  $me = current_admin()['username'] ?? '';
  $new = trim($_POST['newpass'] ?? '');
  if($me===''||$new===''){ echo json_encode(['ok'=>0]); exit; }
  echo json_encode(['ok'=> change_admin_pass($me,$new)?1:0]); exit;
}

/* ============ Discounts (codes.json) ============ */
define('DISCOUNT_DB', dirname(__DIR__).'/discounts/codes.json');
@mkdir(dirname(DISCOUNT_DB),0777,true);
function json_load($p,$fb=[]){ $s=@file_get_contents($p); $j=@json_decode($s,true); return is_array($j)?$j:$fb; }
function json_save($p,$d){ @file_put_contents($p,json_encode($d,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT)); }

if($act==='disc_list'){
  $db = json_load(DISCOUNT_DB,[]);
  $items=[];
  foreach($db as $code=>$row){
    $items[] = [
      'code'=>$code,
      'percent'=>$row['percent']??0,
      'expire_at'=>$row['expire_at']??0,
      'active'=>!empty($row['is_active']),
      'uses'=>$row['uses']??0,
      'servers'=>!empty($row['servers'])?$row['servers']:['1','2','1+2'],
    ];
  }
  echo json_encode(['ok'=>1,'items'=>$items]); exit;
}
if($act==='disc_add'){
  $code = strtoupper(trim($_POST['code']??''));
  $percent = (int)($_POST['percent']??0);
  $days = (int)($_POST['days']??0);
  $servers = $_POST['servers'] ?? ['1','2','1+2'];
  if($code===''||$percent<1||$percent>90){ echo json_encode(['ok'=>0,'err'=>'bad']); exit; }
  $db = json_load(DISCOUNT_DB,[]);
  $exp = $days>0 ? (time()+$days*86400) : 0;
  $db[$code] = ['percent'=>$percent,'expire_at'=>$exp,'is_active'=>true,'created_at'=>time(),'uses'=>0,'servers'=>$servers];
  json_save(DISCOUNT_DB,$db);

  // notify
  $who = (current_admin()['name'] ?: current_admin()['username'] ?? 'admin');
  $chat = current_admin()['chat_id'] ?? '';
  tg_send($chat, "🎟 کد تخفیف جدید ثبت شد\nکد: $code\n٪$percent\nتوسط: $who");

  echo json_encode(['ok'=>1]); exit;
}
if($act==='disc_del'){
  $code = strtoupper(trim($_POST['code']??''));
  $db = json_load(DISCOUNT_DB,[]);
  if(isset($db[$code])){ unset($db[$code]); json_save(DISCOUNT_DB,$db); echo json_encode(['ok'=>1]); }
  else echo json_encode(['ok'=>0]);
  exit;
}

/* ============ Users (file-based) ============ */
function user_dir(){ return dirname(__DIR__).'/data'; }
function user_info_from_files($uid){
  $d = user_dir()."/$uid";
  return [
    'uid'=>$uid,
    'phone'=>trim(@file_get_contents($d.'/phone.txt')) ?: '',
    'steamid'=>trim(@file_get_contents($d.'/steamid.txt')) ?: '',
    'username'=>trim(@file_get_contents($d.'/username.txt')) ?: '',
    'coin'=>(int)trim(@file_get_contents($d.'/price.txt')),
  ];
}
if($act==='users_list'){
  $out=[];
  foreach((array)glob(user_dir().'/*', GLOB_ONLYDIR) as $dir){
    $uid = basename($dir);
    $info = user_info_from_files($uid);
    $out[] = $info;
  }
  echo json_encode(['ok'=>1,'items'=>$out]); exit;
}
if($act==='user_search'){
  $type = $_POST['type'] ?? 'uid';
  $q = trim((string)($_POST['q'] ?? ''));
  $res=[];
  foreach((array)glob(user_dir().'/*', GLOB_ONLYDIR) as $dir){
    $uid = basename($dir);
    $info = user_info_from_files($uid);
    $hit=false;
    if($type==='uid' && $uid===$q) $hit=true;
    if($type==='phone' && $info['phone']===$q) $hit=true;
    if($type==='steamid' && $info['steamid']===$q) $hit=true;
    if($type==='username' && $info['username']===$q) $hit=true;
    if($hit) $res[]=$info;
  }
  echo json_encode(['ok'=>1,'items'=>$res]); exit;
}
if($act==='wallet_set'){
  $uid = trim($_POST['uid']??''); $delta = (int)($_POST['delta']??0);
  if($uid===''){ echo json_encode(['ok'=>0]); exit; }
  $d = user_dir()."/$uid"; @mkdir($d,0777,true);
  $file = $d.'/price.txt';
  $cur = (int)trim(@file_get_contents($file));
  $new = $cur + $delta;
  if($new<0) $new=0;
  @file_put_contents($file, (string)$new);

  // notify
  $who = (current_admin()['name'] ?: current_admin()['username'] ?? 'admin');
  $chat = current_admin()['chat_id'] ?? '';
  if($delta>0) tg_send($chat, "➕ $who مبلغ ".number_format($delta)." تومان به کیف پول #$uid افزود.");
  if($delta<0) tg_send($chat, "➖ $who مبلغ ".number_format(abs($delta))." تومان از کیف پول #$uid کسر کرد.");

  echo json_encode(['ok'=>1,'new'=>$new]); exit;
}

/* ============ Orders (file-based) approve/reject + notify) ============ */
if($act==='order_set'){
  $oid = basename($_POST['oid'] ?? '');
  $status = $_POST['status'] ?? '';
  $f = dirname(__DIR__)."/orders/$oid.json";
  if(!is_file($f)){ echo json_encode(['ok'=>0]); exit; }
  $j = @json_decode(@file_get_contents($f), true);
  if(!$j){ echo json_encode(['ok'=>0]); exit; }

  if($status==='approved' || ($status==='incomplete' && $j['status']!=='approved')){
    $j['status'] = $status;
    @file_put_contents($f, json_encode($j, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));

    // notify buyer (اگر chat ذخیره شده)
    $buyer_chat = $j['buyer_chat'] ?? '';
    if($buyer_chat && BOT_TOKEN){
      $msg = ($status==='approved')
        ? "✅ سفارش شما تایید و تحویل شد.\nمحصول: {$j['product_id']}\nمبلغ: {$j['price']}"
        : "⛔ سفارش شما ناقص/رد شد.\nمحصول: {$j['product_id']}";
      $url="https://api.telegram.org/bot".BOT_TOKEN."/sendMessage?chat_id=".$buyer_chat."&text=".urlencode($msg);
      @file_get_contents($url);
    }
    // notify admin
    $who = (current_admin()['name'] ?: current_admin()['username'] ?? 'admin');
    $chat = current_admin()['chat_id'] ?? '';
    tg_send($chat, "🛒 وضعیت سفارش $oid توسط $who → ".($status==='approved'?'✔️ تایید':'⛔ ناقص'));

    echo json_encode(['ok'=>1]); exit;
  }
  echo json_encode(['ok'=>0]); exit;
}

echo json_encode(['ok'=>0,'err'=>'noaction']);
