<?php
// bot/shopfun/admin-api.php
if (session_status()===PHP_SESSION_NONE) session_start();
require __DIR__.'/funs/auth.php';      // فقط افراد لاگین‌شده
header('Content-Type: application/json; charset=utf-8');

define('ORDERS_DIR', __DIR__.'/orders');
@mkdir(ORDERS_DIR,0777,true);

// اگر توکن بات رو اینجا هم می‌خوای هاردکد کنی:
if (!defined('API')) {
  // define('API','8051610396:AAGtHNbK8Qymym_llZ4uv7r5DenWF1wlHJ8'); // ← درصورت نیاز
}

function tg_send($chat_id,$text){
  if (!defined('API') || !API) return;
  $url = "https://api.telegram.org/bot".API."/sendMessage";
  @file_get_contents($url.'?chat_id='.$chat_id.'&text='.urlencode($text));
}
function load_order($oid){
  $file = ORDERS_DIR.'/'.basename($oid).'.json';
  if (!is_file($file)) return [null,null];
  $j = json_decode(@file_get_contents($file), true);
  return [$j,$file];
}
function save_order($file,$data){
  @file_put_contents($file, json_encode($data, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
}

$body = json_decode(file_get_contents('php://input'), true) ?: [];
$act  = $body['act'] ?? '';
$oid  = $body['oid'] ?? '';

if ($act==='order_set' && $oid){
  list($o,$file) = load_order($oid);
  if (!$o){ echo json_encode(['ok'=>false,'msg'=>'سفارش یافت نشد']); exit; }
  $new = $body['status'] ?? '';
  if (!in_array($new,['approved','incomplete'],true)){ echo json_encode(['ok'=>false,'msg'=>'وضعیت نامعتبر']); exit; }

  // جلوگیری از تغییر approved به ناقص؟ (طبق باتت اجازه نمی‌داد) — اختیاری:
  if (($o['status']??'pending')==='approved' && $new==='incomplete'){
    echo json_encode(['ok'=>false,'msg'=>'نمی‌توان سفارش تایید شده را ناقص کرد']); exit;
  }

  $o['status']=$new;
  save_order($file,$o);

  // پیام‌ها
  $buyer_chat = $o['buyer_chat'] ?? $o['buyer_id'] ?? null;  // اگر chat ذخیره شده، همونو بفرست
  $admin_id   = 7167180963;                                   // ادمین اصلی‌ت (می‌تونی از فایل بخونی بعداً)
  $pname      = $o['product_id'] ?? $o['product_code'] ?? '';
  $price      = $o['price'] ?? 0;
  $server     = $o['server'] ?? '';
  if ($new==='approved'){
    if ($buyer_chat) tg_send($buyer_chat,"✅ سفارش شما تایید و تحویل داده شد.\n📦 $pname\n💰 مبلغ: $price\n🖥 سرور: $server");
    tg_send($admin_id,"✔️ سفارش «{$oid}» تایید شد توسط ".$_SESSION['username']);
  } else {
    if ($buyer_chat) tg_send($buyer_chat,"⛔ سفارش شما ناقص/رد شد.\n📦 $pname\n💬 در صورت سوال به پشتیبانی پیام دهید.");
    tg_send($admin_id,"⛔ سفارش «{$oid}» ناقص شد توسط ".$_SESSION['username']);
  }

  echo json_encode(['ok'=>true,'msg'=>'ثبت شد','status'=>$new]); exit;
}

/* ---------- مدیریت ادمین‌ها (فقط sudo) ---------- */
if ($act==='admin_add' && is_sudo()){
  list($ok,$msg) = admin_add($body['username']??'', $body['password']??'');
  echo json_encode(['ok'=>$ok,'msg'=>$msg]); exit;
}
if ($act==='admin_delete' && is_sudo()){
  $del = admin_delete_many($body['usernames']??[]);
  echo json_encode(['ok'=>true,'msg'=>"حذف $del کاربر"]); exit;
}

/* ---------- نمونه هوک تخفیف‌ها از فایل codes.json ---------- */
define('DISCOUNT_DB', __DIR__.'/discounts/codes.json');
@mkdir(dirname(DISCOUNT_DB),0777,true);

if ($act==='disc_list'){
  $db = is_file(DISCOUNT_DB) ? json_decode(file_get_contents(DISCOUNT_DB),true):[];
  echo json_encode(['ok'=>true,'data'=>$db]); exit;
}
if ($act==='disc_add'){
  $code = strtoupper(trim($body['code']??''));
  $percent = (int)($body['percent']??0);
  if ($code==='' || $percent<1 || $percent>90){ echo json_encode(['ok'=>false,'msg'=>'کد/درصد نامعتبر']); exit; }
  $db = is_file(DISCOUNT_DB) ? json_decode(file_get_contents(DISCOUNT_DB),true):[];
  $db[$code] = [
    'percent'=>$percent,'expire_at'=> (int)($body['expire_at']??0),
    'is_active'=> true,'created_at'=>time(),'uses'=>0,'servers'=> $body['servers']??['1','2','1+2'],
  ];
  file_put_contents(DISCOUNT_DB,json_encode($db,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
  // پیام به تلگرام:
  $admin_id = 7167180963;
  tg_send($admin_id,"🎟 کد تخفیف جدید ساخته شد:\nکد: $code\n٪$percent\nتوسط: ".$_SESSION['username']);
  echo json_encode(['ok'=>true,'msg'=>'ثبت شد']); exit;
}
if ($act==='disc_delete'){
  $db = is_file(DISCOUNT_DB) ? json_decode(file_get_contents(DISCOUNT_DB),true):[];
  foreach ((array)($body['codes']??[]) as $c){ unset($db[$c]); }
  file_put_contents(DISCOUNT_DB,json_encode($db,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
  echo json_encode(['ok'=>true,'msg'=>'حذف شد']); exit;
}

echo json_encode(['ok'=>false,'msg'=>'action?']);