<?php
// bot/shopfun/webapp/support-admin_api.php
session_start();
error_reporting(0);
date_default_timezone_set('Asia/Tehran');

if (!isset($_SESSION['auth'])) { echo json_encode(['ok'=>false,'error'=>'NO_AUTH']); exit; }

$uid = preg_replace('/\D/','', (string)($_POST['uid'] ?? ''));
$act = $_POST['action'] ?? 'send';
if (!$uid) { echo json_encode(['ok'=>false,'error'=>'NO_UID']); exit; }

$base = realpath(__DIR__.'/..').'/support/'.$uid;
@mkdir($base, 0777, true);

function jload($p,$d=[]){ $j=@json_decode(@file_get_contents($p),true); return is_array($j)?$j:$d; }
function jsave($p,$a){ @file_put_contents($p,json_encode($a,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT)); }

$store = $base.'/messages.json';

/* ---------- لود لایو برای ادمین ---------- */
if ($act === 'load') {
  $after = (int)($_POST['after'] ?? 0);
  $db = jload($store, []);
  // فقط پیام‌های بعد از after
  $out = array_values(array_filter($db, function($m) use($after){
    return (int)$m['id'] > $after;
  }));
  echo json_encode(['ok'=>true,'items'=>$out]); exit;
}

/* ---------- ارسال متن/فایل توسط ادمین ---------- */
$db = jload($store, []);
$nextId = (count($db) ? (int)end($db)['id'] : 0) + 1;

if (!empty($_FILES['file']['tmp_name'])) {
  @mkdir(__DIR__.'/uploads',0777,true);
  $ext  = strtolower(pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION));
  $type = (preg_match('/^audio/i', $_FILES['file']['type'])) ? 'audio' : 'image';
  $name = 'admin_'.$uid.'_'.time().'.'.$ext;
  $dst  = __DIR__.'/uploads/'.$name;

  if (@move_uploaded_file($_FILES['file']['tmp_name'],$dst)) {
    $db[] = ['id'=>$nextId,'ts'=>time(),'from'=>'admin','type'=>$type,'url'=>'uploads/'.$name];
    jsave($store,$db);
    echo json_encode(['ok'=>true,'id'=>$nextId]); exit;
  }
  echo json_encode(['ok'=>false]); exit;
} else {
  $text = trim((string)($_POST['text'] ?? ''));
  if ($text === '') { echo json_encode(['ok'=>false]); exit; }
  $db[] = ['id'=>$nextId,'ts'=>time(),'from'=>'admin','type'=>'text','text'=>$text];
  jsave($store,$db);
  echo json_encode(['ok'=>true,'id'=>$nextId]); exit;
}
