<?php
// /bot/shopfun/webapp/support-admin.php
session_start();
error_reporting(E_ALL);
ini_set('display_errors',1);
date_default_timezone_set('Asia/Tehran');

// ✅ ورود جدید
require_once __DIR__.'/../funs/auth.php';
auth_gate('webapp/support-admin.php'); // فقط ادمین‌های لاگین‌شده

$base = realpath(__DIR__.'/../support');
@mkdir($base,0777,true);
// Helpers
function jload($p,$d=[]){ $j=@json_decode(@file_get_contents($p),true); return is_array($j)?$j:$d; }
function jsave($p,$a){ @file_put_contents($p,json_encode($a,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT)); }
function list_chats($base){
  $out=[];
  foreach((array)scandir($base) as $id){
    if($id==='.'||$id==='..') continue;
    if(is_dir("$base/$id")){
      $msgs = jload("$base/$id/messages.json",[]);
      $last = end($msgs);
      $out[]=['uid'=>$id,'count'=>count($msgs),'last'=>$last['text']??($last['type']??'-')];
    }
  }
  usort($out, function($a,$b){ return $b['count'] <=> $a['count']; });
  return $out;
}

$uid = preg_replace('/\D/','', (string)($_GET['uid'] ?? ''));
if(isset($_POST['close']) && $uid){
  // بستن چت: پاک‌کردن فولدر
  $dir = "$base/$uid";
  $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir, FilesystemIterator::SKIP_DOTS), RecursiveIteratorIterator::CHILD_FIRST);
  foreach($it as $f){ $f->isDir()? @rmdir($f->getPathname()): @unlink($f->getPathname()); }
  @rmdir($dir);
  header('Location: support-admin.php'); exit;
}

?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1" />
<title>پشتیبانی | FunWorld</title>
<style>
  :root{--bg:#0b1220;--card:#0f172a;--muted:#94a3b8;--text:#e5e7eb;--line:#1f2937}
  body{margin:0;background:var(--bg);color:var(--text);font-family:IRANSans,Segoe UI,Tahoma,Arial}
  .wrap{display:flex;min-height:100vh}
  .side{width:260px;background:#0f172a;border-inline-end:1px solid var(--line);padding:12px}
  .main{flex:1;padding:12px}
  .item{padding:10px;border:1px solid var(--line);border-radius:12px;background:#0b1220;margin-bottom:8px}
  .chat{height:70vh;overflow:auto;border:1px solid var(--line);border-radius:12px;background:#0b1220;padding:10px;display:flex;flex-direction:column;gap:8px}
  .msg{max-width:75%;padding:8px 10px;border-radius:14px}
  .me{align-self:flex-start;background:#1d2a44}
  .user{align-self:flex-end;background:#111827}
  input,textarea{width:100%;padding:10px 12px;border:1px solid var(--line);border-radius:12px;background:#0b1220;color:#e5e7eb}
  .row{display:flex;gap:6px;align-items:center}
  .btn{padding:8px 12px;border:1px solid var(--line);border-radius:10px;background:#0f172a;color:#e5e7eb;cursor:pointer}
</style>
</head>
<body>
<div class="wrap">
  <aside class="side">
    <div style="margin-bottom:10px;font-weight:700">گفت‌وگوها</div>
    <?php foreach(list_chats($base) as $c): ?>
      <a class="item" href="?uid=<?=$c['uid']?>">#<?=$c['uid']?> <div style="font-size:12px;color:#94a3b8">پیام‌ها: <?=$c['count']?> | آخرین: <?=htmlspecialchars($c['last'])?></div></a>
    <?php endforeach; ?>
    <div style="margin-top:8px"><a class="btn" href="../admin-monitor.php">⟵ مانیتورینگ</a></div>
  </aside>
  <main class="main">
    <?php if(!$uid): ?>
      <div class="item">یک گفت‌وگو را از ستون کناری انتخاب کنید.</div>
    <?php else:
      $db = jload("$base/$uid/messages.json",[]);
    ?>
      <div style="margin-bottom:8px">کاربر: <b>#<?=$uid?></b></div>
      <div class="chat" id="box">
  <?php foreach($db as $m): 
    $cls = ($m['from']==='admin' ? 'me' : 'user'); ?>
    <div class="msg <?=$cls?>"><?php
      $type = $m['type'] ?? 'text';
      if($type==='text') echo htmlspecialchars($m['text']);
      elseif($type==='image') echo '<img src="'.htmlspecialchars('../webapp/'.$m['url']).'" style="max-width:240px;border-radius:10px">';
      elseif($type==='audio') echo '<audio controls src="'.htmlspecialchars('../webapp/'.$m['url']).'"></audio>';
    ?></div>
  <?php endforeach; ?>
</div>

      <form class="row" style="margin-top:8px" method="post" action="support-admin_api.php" enctype="multipart/form-data" target="h">
        <input type="hidden" name="uid" value="<?=$uid?>">
        <input type="text" name="text" placeholder="پیام به کاربر...">
        <input type="file" name="file" accept="image/*,audio/*">
        <button class="btn" type="submit">ارسال</button>
      </form>
      <form method="post" style="margin-top:8px" onsubmit="return confirm('کل چت حذف شود؟')">
        <input type="hidden" name="close" value="1">
        <button class="btn" type="submit" style="background:#7f1d1d">بستن چت (حذف همه)</button>
      </form>
      <iframe name="h" style="display:none"></iframe>
    <?php endif; ?>
  </main>
</div>
<script>
let LAST_ID = (function(){
  const box = document.getElementById('box'); 
  if(!box) return 0;
  // پیدا کردن آخرین id از DOM لازم نیست؛ از فایل نمی‌آید. صفر بگذاریم و اولین بار کل دیتای موجود را نمی‌گیریم.
  return 0;
})();

async function adminLoad() {
  const uid = new URLSearchParams(location.search).get('uid') || '';
  if(!uid) return;
  const fd = new FormData();
  fd.append('action','load'); fd.append('uid',uid); fd.append('after',LAST_ID);
  const r = await fetch('support-admin_api.php', {method:'POST', body:fd}).then(x=>x.json()).catch(()=>({ok:false}));
  if(!r.ok || !r.items) return;
  const box = document.getElementById('box');
  r.items.forEach(m=>{
    const div = document.createElement('div');
    div.className = 'msg ' + (m.from==='admin'?'me':'user');
    if(m.type==='text') div.textContent = m.text;
    else if(m.type==='image') div.innerHTML = `<img src="../webapp/${m.url}" style="max-width:240px;border-radius:10px">`;
    else if(m.type==='audio') div.innerHTML = `<audio controls src="../webapp/${m.url}"></audio>`;
    box.appendChild(div);
    LAST_ID = m.id;
    box.scrollTop = box.scrollHeight;
  });
}

(function startPolling(){
  if (!document.getElementById('box')) return;
  adminLoad();
  setInterval(adminLoad, 2000); // 2s
})();

// هندل فرم ارسال تا بدون رفرش کار کند
const form = document.querySelector('form[action="support-admin_api.php"]');
if (form) {
  form.addEventListener('submit', async (e)=>{
    e.preventDefault();
    const fd = new FormData(form);
    fd.append('action', form.querySelector('[name="file"]').files[0] ? '' : 'send');
    const r = await fetch('support-admin_api.php', {method:'POST', body:fd}).then(x=>x.json()).catch(()=>({ok:false}));
    if(r.ok){
      form.reset();
      adminLoad();
    }
  });
}
</script>

</body>
</html>
