<?php
// bot/shopfun/webapp/index.php
// MiniApp for Telegram – FunWorld

// امنیت ساده‌ی استاتیک (اختیاری): Cross-origin
header('X-Frame-Options: ALLOWALL');
?><!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1" />
<title>FunWorld WebApp</title>
<script src="https://telegram.org/js/telegram-web-app.js"></script>
<style>
:root{
  --bg:#0b1220; --card:#0f172a; --muted:#94a3b8; --text:#e5e7eb;
  --line:#1f2937; --accent:#22d3ee; --ok:#22c55e; --bad:#ef4444; --wait:#f59e0b;
}
*{box-sizing:border-box} html,body{height:100%}
body{margin:0;background:var(--bg);color:var(--text);font-family:IRANSans,Segoe UI,Tahoma,Arial}
a{color:#93c5fd;text-decoration:none}
.container{max-width:640px;margin:0 auto;padding:12px}
header{position:sticky;top:0;z-index:5;background:linear-gradient(180deg,#0b1220 90%, transparent);padding:10px 12px;border-bottom:1px solid var(--line)}
.head{display:flex;justify-content:space-between;align-items:center;gap:8px}
.wallet{font-size:13px;background:#0b1220;border:1px solid var(--line);padding:8px 12px;border-radius:12px;display:flex;gap:8px;align-items:center}
.avatar{width:34px;height:34px;border-radius:50%;border:1px solid #23304a;object-fit:cover;cursor:pointer}
.name{font-weight:600;font-size:13px;color:#dbeafe}
.grid-menu{display:grid;grid-template-columns:1fr;gap:10px;margin-top:14px}
.btn{display:block;width:100%;padding:14px 16px;border:1px solid var(--line);border-radius:14px;background:#0f172a;color:var(--text);text-align:center;cursor:pointer;transition:.2s}
.btn:active{transform:scale(.98)}
.card{background:#0f172a;border:1px solid var(--line);border-radius:16px;padding:14px;margin-top:12px}
.title{font-size:15px;margin:0 0 10px}
.row{display:flex;gap:8px;flex-wrap:wrap;align-items:center}
.pill{padding:6px 10px;border:1px solid var(--line);border-radius:999px;font-size:12px;white-space:nowrap;background:#0b1220}
.sel{background:#1d2a44}
.list{display:flex;flex-direction:column;gap:8px}
.item{padding:12px;border:1px solid var(--line);border-radius:12px;background:#0b1220;display:flex;justify-content:space-between;align-items:center}
.price{opacity:.9}
.actions{display:flex;gap:8px}
.input, input, select{width:100%;padding:10px 12px;border:1px solid var(--line);border-radius:12px;background:#0b1220;color:#e5e7eb}
label{font-size:12px;color:var(--muted)}
.center{display:flex;justify-content:center}
.big{font-size:18px}
.muted{color:var(--muted)}
.badge{padding:4px 10px;border-radius:10px;border:1px solid var(--line);font-size:12px}
.b-ok{background:rgba(34,197,94,.15);color:#86efac}
.b-bad{background:rgba(239,68,68,.15);color:#fecaca}
.b-wait{background:rgba(245,158,11,.15);color:#fde68a}
hr{border:none;border-top:1px dashed var(--line);margin:10px 0}
.hidden{display:none}

/* Modal */
.modal{position:fixed;inset:0;display:none;align-items:center;justify-content:center;background:rgba(0,0,0,.55);z-index:50;padding:16px}
.modal.open{display:flex}
.modal-card{width:100%;max-width:420px;background:#0f172a;border:1px solid var(--line);border-radius:14px;padding:14px}
.modal-head{display:flex;justify-content:space-between;align-items:center;margin-bottom:8px}
.close{background:#1f2937;border:1px solid var(--line);color:#e5e7eb;border-radius:10px;padding:6px 10px;cursor:pointer}

/* Chat */
.chatbox{height:60vh;overflow:auto;border:1px solid var(--line);border-radius:12px;background:#0b1220;padding:10px;display:flex;flex-direction:column;gap:8px}
.msg{max-width:80%;padding:8px 10px;border-radius:14px}
.me{align-self:flex-end;background:#1d2a44}
.admin{align-self:flex-start;background:#111827}
.chat-input{display:flex;gap:6px}
.file{display:none}

/* Scroll */
.chatbox::-webkit-scrollbar, .list::-webkit-scrollbar { width:8px }
.chatbox::-webkit-scrollbar-thumb, .list::-webkit-scrollbar-thumb { background:#1e2b45;border-radius:8px }
</style>
</head>
<body>
<header>
  <div class="head">
    <div class="wallet">
      <span>مدیریت کیف پول | موجودی: <b id="bal">0</b></span>
    </div>
    <div class="row">
      <img id="av" class="avatar" src="" alt="">
      <div class="name" id="uname">—</div>
    </div>
  </div>
</header>

<div class="container">

  <!-- صفحه اصلی -->
  <section id="home">
    <div class="grid-menu">
      <button class="btn" onclick="nav('shop')">🛒 فروشگاه</button>
      <button class="btn" onclick="nav('account')">👤 حساب کاربری</button>
      <button class="btn" onclick="nav('support')">💬 پشتیبانی</button>
    </div>
  </section>

  <!-- فروشگاه: انتخاب سرور -->
  <section id="shop" class="hidden">
    <div class="card">
      <h3 class="title">سرورهای موردنظر را انتخاب کنید</h3>
      <div class="row">
        <button id="srv1" class="pill" onclick="toggleSrv('1')">Fun City</button>
        <button id="srv2" class="pill" onclick="toggleSrv('2')">Fun Zone</button>
        <button id="srvb" class="pill" onclick="toggleSrv('1+2')">هر دو</button>
      </div>
      <div class="actions" style="margin-top:10px">
        <button class="btn" onclick="loadProducts()">ادامه</button>
        <button class="btn" onclick="nav('home')">بازگشت</button>
      </div>
    </div>

    <div class="card hidden" id="prodCard">
      <h3 class="title">محصولات</h3>
      <div id="prodList" class="list"></div>
    </div>

    <div class="card hidden" id="invoiceCard">
      <h3 class="title">پیش‌فاکتور</h3>
      <div id="invBody"></div>
      <div id="steamGuard" class="hidden">
        <label>استیم آیدی خود را وارد کنید</label>
        <input id="steamInput" placeholder="7656..." />
        <div class="actions" style="margin-top:8px">
          <button class="btn" onclick="saveSteam()">ذخیره</button>
        </div>
      </div>
      <div id="payBtns" class="actions hidden" style="margin-top:10px">
        <button class="btn" onclick="payWallet()">پرداخت از کیف پول</button>
        <button class="btn" onclick="payOnline()">پرداخت آنلاین</button>
      </div>
      <div class="actions" style="margin-top:10px">
        <button class="btn" onclick="backToProducts()">بازگشت به محصولات</button>
      </div>
    </div>
  </section>

  <!-- حساب کاربری -->
  <section id="account" class="hidden">
    <div class="center" style="margin-top:10px"><img id="accAv" class="avatar" style="width:84px;height:84px" src=""></div>
    <div class="center" style="margin-top:8px"><div class="big" id="accName">—</div></div>
    <div class="card">
      <div class="row" style="justify-content:space-between">
        <div>استیم آیدی: <b id="accSteam">—</b></div>
        <div class="actions">
          <button class="btn" onclick="openSteamEdit()">ویرایش</button>
          <a id="steamLink" class="btn" target="_blank" href="#">مشاهده پروفایل استیم</a>
        </div>
      </div>
      <hr>
      <div class="row" style="justify-content:space-between">
        <div>موجودی کیف پول: <b id="accBal">0</b></div>
        <button class="btn" onclick="openCharge()">شارژ حساب</button>
      </div>
    </div>

    <div class="card">
      <h3 class="title">هیستوری خرید</h3>
      <div id="hist" class="list"></div>
    </div>

    <div class="actions" style="margin-top:12px">
      <button class="btn" onclick="nav('home')">بازگشت</button>
    </div>
  </section>

  <!-- پشتیبانی -->
  <section id="support" class="hidden">
    <div class="row" style="align-items:center;gap:10px;margin:6px 0">
      <img src="../assets/profile.png" class="avatar" style="width:40px;height:40px" alt="">
      <div>
        <div style="font-weight:700">Fun World Support</div>
        <div class="muted" style="font-size:12px">ارتباط مستقیم با پشتیبان</div>
      </div>
    </div>
    <div id="chat" class="chatbox"></div>
    <div class="row chat-input" style="margin-top:8px">
      <input id="msg" class="input" placeholder="پیام خود را بنویسید..." onkeydown="if(event.key==='Enter') sendMsg()">
      <input id="file" class="file" type="file" accept="image/*,audio/*">
      <button class="btn" onclick="document.getElementById('file').click()">📎</button>
      <button class="btn" onclick="sendMsg()">ارسال</button>
    </div>
    <div class="actions" style="margin-top:10px">
      <button class="btn" onclick="nav('home')">بازگشت</button>
    </div>
  </section>

</div>

<!-- مودال‌ها: آواتار بزرگ / شارژ / ویرایش استیم -->
<div class="modal" id="modal-avatar">
  <div class="modal-card">
    <div class="modal-head">
      <div>پروفایل</div><button class="close" onclick="closeModal('modal-avatar')">بستن</button>
    </div>
    <div class="center"><img id="bigAv" style="width:220px;height:220px;border-radius:50%;border:1px solid #23304a;object-fit:cover" src=""></div>
  </div>
</div>

<div class="modal" id="modal-charge">
  <div class="modal-card">
    <div class="modal-head"><div>شارژ کیف پول</div><button class="close" onclick="closeModal('modal-charge')">بستن</button></div>
    <label>مبلغ به تومان</label>
    <input id="chargeAmt" type="number" placeholder="10000" />
    <div class="actions" style="margin-top:10px"><button class="btn" onclick="charge()">ادامه به پرداخت</button></div>
  </div>
</div>

<div class="modal" id="modal-editsteam">
  <div class="modal-card">
    <div class="modal-head"><div>ویرایش استیم آیدی</div><button class="close" onclick="closeModal('modal-editsteam')">بستن</button></div>
    <input id="editSteamVal" placeholder="7656..." />
    <div class="actions" style="margin-top:10px"><button class="btn" onclick="saveSteamFromAccount()">ذخیره</button></div>
  </div>
</div>

<script>
/* ====== Telegram init ====== */
const tg = window.Telegram.WebApp;
tg.expand(); // تمام قد
let user = tg.initDataUnsafe?.user || null; // از تلگرام
let UID = user?.id || null;

const api = (action, payload={}) =>
  fetch('api.php?action='+encodeURIComponent(action), {
    method:'POST',
    body:Object.entries({...payload, uid:UID}).reduce((f,[k,v])=>{f.append(k,v);return f}, new FormData())
  }).then(r=>r.json());

/* ====== State ====== */
let STATE = { servers: new Set(), products: [], chosen: null, price:0, steam:'', balance:0 };

/* ====== Helpers ====== */
const el = id => document.getElementById(id);
const nav = id => {
  ['home','shop','account','support'].forEach(s=>el(s).classList.toggle('hidden', s!==id));
  if(id==='account') loadAccount();
  if(id==='support'){ loadChat(); startPolling(); }
};
const openModal = id => el(id).classList.add('open');
const closeModal = id => el(id).classList.remove('open');

function toggleSrv(s){
  if(s==='1+2'){ // شورتکات هر دو
    STATE.servers.clear(); STATE.servers.add('1'); STATE.servers.add('2'); 
    ['srv1','srv2','srvb'].forEach(id=>el(id).classList.remove('sel'));
    el('srv1').classList.add('sel'); el('srv2').classList.add('sel'); el('srvb').classList.add('sel');
    return;
  }
  if(STATE.servers.has(s)) STATE.servers.delete(s); else STATE.servers.add(s);
  el('srv1').classList.toggle('sel', STATE.servers.has('1'));
  el('srv2').classList.toggle('sel', STATE.servers.has('2'));
  el('srvb').classList.toggle('sel', STATE.servers.size===2);
}

async function boot(){
  // پروفایل/بالانس
  const info = await api('get_user');
  STATE.balance = +info.balance||0;
  STATE.steam = info.steam||'';
  const av = info.avatar || 'https://amirhajian.com/pic/none.png';
  el('bal').textContent = new Intl.NumberFormat().format(STATE.balance);
  el('accBal').textContent = el('bal').textContent;
  el('av').src = av; el('accAv').src = av; el('bigAv').src = av;
  el('uname').textContent = info.username || ('#'+UID);
  el('accName').textContent = info.username || ('#'+UID);
  el('accSteam').textContent = STATE.steam || '—';
  el('steamLink').href = STATE.steam ? ('https://steamcommunity.com/profiles/'+STATE.steam) : '#';

  // کلیک آواتار
  el('av').onclick = ()=>openModal('modal-avatar');
  el('accAv').onclick = ()=>openModal('modal-avatar');

  // اگر از verify برگشته
  if(location.hash.includes('paid=1')){
    const box = document.createElement('div');
    box.className='card';
    box.innerHTML = `<div class="title">پرداخت موفق ✅</div>
      <pre class="input" style="white-space:pre-wrap;max-height:200px;overflow:auto"></pre>
      <div class="actions" style="margin-top:8px"><button class="btn" onclick="location.hash=''; nav('home')">بازگشت به صفحه اصلی</button></div>`;
    document.querySelector('.container').prepend(box);
    fetch('../assets/confirmed.json').then(r=>r.text()).then(t=>box.querySelector('pre').textContent=t);
  }
}
boot();

/* ====== Shop ====== */
async function loadProducts(){
  if(STATE.servers.size===0){ tg.showPopup({title:'توجه',message:'حداقل یک سرور انتخاب کنید.'}); return; }
  const res = await api('list_products');
  STATE.products = res.items||[];
  const L = el('prodList'); L.innerHTML='';
  STATE.products.forEach(p=>{
    const row = document.createElement('div');
    row.className='item';
    row.innerHTML = `<div>${p.name}</div><div class="price">${new Intl.NumberFormat().format(+p.price)} ت</div>`;
    row.onclick=()=>openInvoice(p);
    L.append(row);
  });
  el('prodCard').classList.remove('hidden');
  el('invoiceCard').classList.add('hidden');
}
function backToProducts(){
  el('invoiceCard').classList.add('hidden');
  el('prodCard').classList.remove('hidden');
}
async function openInvoice(p){
  STATE.chosen = p;
  // قیمت × اگر هر دو سرور انتخاب شده
  const both = (STATE.servers.has('1') && STATE.servers.has('2'));
  STATE.price = both ? (+p.price*2) : (+p.price);
  el('invBody').innerHTML = `
    <div class="row"><div class="pill">محصول: <b>${p.name}</b></div>
    <div class="pill">سرورها: ${[...STATE.servers].join(' + ')}</div>
    <div class="pill">قیمت: <b>${new Intl.NumberFormat().format(STATE.price)}</b> ت</div></div>`;
  el('prodCard').classList.add('hidden');
  el('invoiceCard').classList.remove('hidden');
  // نیاز به استیم؟
  if(!STATE.steam){
    el('steamGuard').classList.remove('hidden');
    el('payBtns').classList.add('hidden');
  }else{
    el('steamGuard').classList.add('hidden');
    el('payBtns').classList.remove('hidden');
  }
}
async function saveSteam(){
  const s = el('steamInput').value.trim();
  if(!s){ tg.showAlert('استیم آیدی را وارد کنید.'); return; }
  const r = await api('set_steam',{steam:s});
  if(r.ok){
    STATE.steam=s;
    tg.showPopup({title:'ذخیره شد',message:'استیم آیدی ثبت شد.'});
    el('steamGuard').classList.add('hidden');
    el('payBtns').classList.remove('hidden');
  }
}
async function payWallet(){
  const servers=[...STATE.servers].join(',');
  const r = await api('pay_wallet',{pid:STATE.chosen.code, servers, price:STATE.price});
  if(r.ok){
    tg.showPopup({title:'موفق',message:'سفارش ثبت و از موجودی کسر شد.'});
    el('bal').textContent = new Intl.NumberFormat().format(r.balance);
    el('accBal').textContent = el('bal').textContent;
  }else{
    tg.showAlert(r.error||'خطا');
  }
}
async function payOnline(){
  const servers=[...STATE.servers].join(',');
  const r = await api('pay_online',{pid:STATE.chosen.code, servers, price:STATE.price});
  if(r?.url){ window.location.href = r.url; }
  else tg.showAlert('خطا در ساخت لینک پرداخت');
}

/* ====== Account ====== */
async function loadAccount(){
  const info = await api('get_user_full');
  // history
  const H = info.history||[];
  const box = el('hist'); box.innerHTML='';
  if(!H.length){ box.innerHTML='<div class="muted">—</div>'; return; }
  H.forEach(o=>{
    const div=document.createElement('div'); div.className='item';
    const badge = o.status==='approved'?'b-ok':(o.status==='pending'?'b-wait':'b-bad');
    div.innerHTML=`<div>${o.product} <span class="badge ${badge}">${o.status}</span></div>
                   <div class="price">${new Intl.NumberFormat().format(+o.price)} ت</div>`;
    box.append(div);
  });
}
function openCharge(){ openModal('modal-charge'); }
async function charge(){
  const amt = parseInt(el('chargeAmt').value||'0',10);
  if(amt<10000){ tg.showAlert('حداقل 10000 تومان.'); return; }
  const r = await api('charge_link',{amount:amt});
  if(r?.url) window.location.href=r.url;
}
function openSteamEdit(){ el('editSteamVal').value = STATE.steam||''; openModal('modal-editsteam'); }
async function saveSteamFromAccount(){
  const v = el('editSteamVal').value.trim(); if(!v) return;
  const r = await api('set_steam',{steam:v});
  if(r.ok){
    STATE.steam=v; el('accSteam').textContent=v; el('steamLink').href='https://steamcommunity.com/profiles/'+v;
    closeModal('modal-editsteam');
  }
}

/* ====== Support chat ====== */
let POLL=null, LAST_ID=0;
async function loadChat(){
  const r = await api('support_load',{after:0});
  renderChat(r.items||[]);
}
function renderChat(list){
  const box=el('chat');
  list.forEach(m=>{
    const div=document.createElement('div'); div.className='msg '+(m.from==='me'?'me':'admin');
    if(m.type==='text') div.textContent=m.text;
    else if(m.type==='image') div.innerHTML=`<img src="${m.url}" style="max-width:220px;border-radius:10px">`;
    else if(m.type==='audio') div.innerHTML=`<audio controls src="${m.url}"></audio>`;
    box.append(div); LAST_ID=m.id;
  });
  box.scrollTop=box.scrollHeight;
}
function startPolling(){
  if(POLL) return;
  POLL=setInterval(async ()=>{
    const r = await api('support_load',{after:LAST_ID});
    if(r.items?.length) renderChat(r.items);
  }, 2000);
}
async function sendMsg(){
  const file = el('file').files[0];
  if(file){
    const fd = new FormData();
    fd.append('action','support_send_file'); fd.append('uid',UID); fd.append('file',file);
    const r = await fetch('api.php',{method:'POST',body:fd}).then(x=>x.json());
    if(r.ok){ el('file').value=''; loadChat(); }
    return;
  }
  const t = el('msg').value.trim(); if(!t) return;
  const r = await api('support_send',{text:t});
  if(r.ok){ el('msg').value=''; loadChat(); }
}

</script>
<!-- head -->
<script src="https://unpkg.com/lottie-web/build/player/lottie.min.js"></script>

<!-- ... وقتی location.hash === '#paid=1' -->
<div id="paidBox" style="display:none; text-align:center; padding:16px">
  <div id="lottie" style="width:220px;height:220px;margin:0 auto"></div>
  <h3>پرداخت شما موفقیت‌آمیز بود ✅</h3>
  <button onclick="location.href='index.php'">بازگشت به صفحه اصلی</button>
</div>
<script>
if (location.hash === '#paid=1'){
  document.getElementById('paidBox').style.display='block';
  lottie.loadAnimation({
    container: document.getElementById('lottie'),
    renderer: 'svg',
    loop: false, autoplay: true,
    path: '../assets/confimed.json'
  });
}
</script>

</body>
</html>
